package com.viontech.keliu.websocket;

import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.AlgResult;

import javax.validation.constraints.NotNull;
import javax.websocket.DeploymentException;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;

/**
 * .
 *
 * @author 谢明辉
 * @date 2020/12/22
 */

public class GeneralPoolApi {
    private final AlgApiClient algApiClient;

    public GeneralPoolApi(AlgApiClient algApiClient) {
        this.algApiClient = algApiClient;
    }

    /**
     * 创建空的人员池
     */
    public CompletableFuture<AlgResult> createEmptyPool(@NotNull String poolId) throws IOException, DeploymentException, ParameterExceptin {
        return algApiClient.addPersonPool(poolId, 2, null, null);
    }

    /**
     * 根据人员池名称查询
     */
    public CompletableFuture<AlgResult> queryPool(@NotNull String poolId) throws DeploymentException, IOException, ParameterExceptin {
        return algApiClient.queryPersonPool(0, poolId, null);
    }

    /**
     * 查询所有人员池
     */
    public CompletableFuture<AlgResult> queryPoolS() throws DeploymentException, IOException, ParameterExceptin {
        return algApiClient.queryPersonPool(1, "poolId", null);
    }

    /**
     * 删除人员池
     */
    public CompletableFuture<AlgResult> deletePool(@NotNull String poolId) throws DeploymentException, IOException, ParameterExceptin {
        return algApiClient.delPersonPool(1, poolId, Collections.emptyList(), null);
    }
}
