package com.viontech.keliu.websocket;

import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.AlgResult;
import com.viontech.keliu.model.Person;

import javax.validation.constraints.NotNull;
import javax.websocket.DeploymentException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author 谢明辉
 * @date 2020/12/22
 */

public class GeneralPersonApi {
    private final AlgApiClient algApiClient;

    public GeneralPersonApi(AlgApiClient algApiClient) {
        this.algApiClient = algApiClient;
    }

    /**
     * 添加人员
     */
    public CompletableFuture<AlgResult> addPerson(@NotNull String poolId, @NotNull List<Person> people) throws DeploymentException, IOException, ParameterExceptin {
        return algApiClient.modifyPersonPool(poolId, 2, 2, people, null);
    }

    /**
     * 删除人员
     */
    public CompletableFuture<AlgResult> deletePerson(@NotNull String poolId, @NotNull List<String> personIds) throws DeploymentException, IOException, ParameterExceptin {
        List<Person> people = personIds.stream().map(x -> {
            Person p = new Person();
            p.setPersonId(x);
            return p;
        }).collect(Collectors.toList());

        return algApiClient.delPersonPool(0, poolId, people, null);
    }

    public CompletableFuture<AlgResult> updatePerson(@NotNull String poolId, @NotNull Person person) throws DeploymentException, IOException, ParameterExceptin {
        return algApiClient.updatePerson(poolId, 2, person, null, Collections.emptyMap());
    }

}
