package com.viontech.keliu.utils;


import java.util.Arrays;

/**
 * @author 谢明辉
 * @createDate 2018-11-13
 * @description
 */

public class Util {

    public static boolean isEmpty(String s) {
        return "".equals(s) || s == null;
    }

    public static boolean isNotEmpty(String s) {
        return !isEmpty(s);
    }

    public static double consineVectorSimilarity(Double[] leftVector, Double[] rightVector) {
        if (leftVector.length != rightVector.length) {
            return 1;
        }
        leftVector = transferBodyFeature(leftVector);
        rightVector = transferBodyFeature(rightVector);

        double dotProduct = 0;
        double leftNorm = 0;
        double rightNorm = 0;
        for (int i = 0; i < leftVector.length; i++) {
            dotProduct += leftVector[i] * rightVector[i];
            leftNorm += leftVector[i] * leftVector[i];
            rightNorm += rightVector[i] * rightVector[i];
        }

        return dotProduct / (Math.sqrt(leftNorm) * Math.sqrt(rightNorm));
    }

    /**
     * 将 2110 维的人体特征加权计算得到 2048 维特征数据
     *
     * @param f1 2110 维的人体特征数据
     *
     * @return 加权计算后的结果
     */
    public static Double[] transferBodyFeature(Double[] f1) {
        try {
            int featureLen = f1[0].intValue();
            int npiece = f1[1].intValue();
            Double[] vec1 = Arrays.copyOfRange(f1, 3, 2048 + 3);
            Double[] temp = Arrays.copyOfRange(f1, 3 + featureLen + npiece, f1.length);
            Double[] wt1 = getWeights(temp);
            Double normCoeF1 = 0D;
            for (int i = 0; i < 8; i++) {
                normCoeF1 += wt1[i] * wt1[i] * f1[3 + 2048 + i];
            }
            normCoeF1 = 1 / Math.sqrt(normCoeF1);

            for (int i = 0; i < 2048; i++) {
                vec1[i] = vec1[i] * wt1[i / 256] * normCoeF1;
            }

            return vec1;
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return f1;
    }

    private static Double[] getWeights(Double[] landmarks) {
        Double[] wt = new Double[8];
        Arrays.fill(wt, 1D);

        if (landmarks[15 * 3 + 2] > 0.8 && landmarks[16 * 3 + 2] > 0.8) {
        } else if (landmarks[15 * 3 + 2] > 0.8 || landmarks[16 * 3 + 2] > 0.8) {
            wt[7] = 0.7;
        } else if (landmarks[13 * 3 + 2] > 0.8 && landmarks[14 * 3 + 2] > 0.8) {
            wt[7] = 0.2;
            wt[3] = 0.7;
        } else if (landmarks[13 * 3 + 2] > 0.8 || landmarks[14 * 3 + 2] > 0.8) {
            wt[7] = 0.1;
            wt[3] = 0.4;
        } else if (landmarks[11 * 3 + 2] > 0.7 && landmarks[12 * 3 + 2] > 0.7) {
            wt[7] = 0D;
            wt[3] = 0.2;
            wt[6] = 0.8;
            wt[2] = 1.1;
            wt[5] = 1.1;
        } else {
            wt[7] = 0D;
            wt[3] = 0D;
            wt[6] = 0.3;
            wt[2] = 1.2;
            wt[5] = 1.4;
        }
        return wt;
    }
}
