package com.viontech.keliu.utils;

import com.alibaba.fastjson.JSON;
import com.viontech.keliu.http.*;
import com.viontech.keliu.model.AlgResult;
import com.viontech.keliu.websocket.AlgApiClient;
import org.apache.tomcat.util.http.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public void send(String url, HashMap params, Consumer<AlgResult> callBack) {
        send(url, params, callBack, 1000 * 60 * 5L);
    }

    public void send(String url, HashMap params, Consumer<AlgResult> callBack, Long timeout) {
        String rid = "";
        try {
            rid = (String) params.get("rid");
        } catch (Exception ignore) {
        }
        VionRequest request = new VionRequest();
        request.setReadTimeout(timeout.intValue());
        request.setUri(url);
        request.setBody(params);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        try {
            int len = request.getBodyStr().getBytes(request.getContentEncoding()).length;
            request.addHeader(Headers.CONTENT_LENGTH, Integer.toString(len));
            request.addHeader(Headers.CONTENT_TYPE, HttpContentType.JSON_DATA);
        } catch (Exception e) {
            log.error("", e);
        }
        VionResponse post = post(request);
        String bodyStr = post.getBodyStr();
        AlgResult algResult = null;
        try {
            algResult = JSON.parseObject(bodyStr, AlgResult.class);
        } catch (Exception ignore) {
        } finally {
            if (algResult != null) {
                rid = algResult.getRid();
            }
            callBack.accept(algResult);
            AlgApiClient.rqid_consumer.remove(rid);
        }
    }

    public VionResponse post(VionRequest request) {
        String url;
        String charset = request.getContentEncoding();
        String content = request.getBodyStr();
        HashMap<String, String> header = request.getHeaders();
        VionResponse response = new VionResponse();

        DataOutputStream out = null;
        InputStream is = null;
        try {
            if (request.getParams().isEmpty()) {
                url = request.getUri().toString();
            } else {
                url = String.format("%s?%s", request.getUri().toString(), request.getParamStr());
            }

            URL console = new URL(url);
            HttpURLConnection conn = (HttpURLConnection) console.openConnection(Proxy.NO_PROXY);

            // set timeout
            if (request.getConnectTimeout() != null) {
                conn.setConnectTimeout(request.getConnectTimeout());
            }
            if (request.getReadTimeout() != null) {
                conn.setReadTimeout(request.getReadTimeout());
            }
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            // 添加header
            for (Map.Entry<String, String> entry : header.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }

            conn.connect();
            out = new DataOutputStream(conn.getOutputStream());
            out.write(content.getBytes(charset));
            out.flush();
            int statusCode = conn.getResponseCode();
            response.setHeader(conn.getHeaderFields());
            response.setStatus(statusCode);
            response.setCharset(charset);
            if (statusCode != 200) {
                InputStream errorStream = conn.getErrorStream();
                String errStr = Streams.asString(errorStream, charset);
                log.info("http error,code:[{}],info:[{}]", statusCode, errStr);
                return response;
            }

            is = conn.getInputStream();
            if (is != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                response.setBody(outStream.toByteArray());
            }
            return response;
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return response;
    }
}
