package com.viontech.keliu.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;
import java.util.Set;

@Getter
@Setter
@Accessors(chain = true)
@ToString
@SuppressWarnings("ALL")
public class Person {

    /** 对应人脸抓拍的 personUnid */
    private String personId;
    private String personPoolId;
    private String inTime;
    private List<BodyFeature> bodyFeatures;
    private List<FaceFeature> faceFeatures;
    private String cameraId;
    private String trackTime;
    private String direction;
    private Integer age;
    private String gender;
    private String outTime;
    private Float score;

    /** 汉堡王新增参数Reid */
    private String captureUnid;//抓拍的唯一标识
    private String originalPersonUnid;//原有的personUnid
    private String newPersonUnid;//纠正后的personUnid
    private Short originalPersonType;//原有的人员类型//0:顾客　1:店员  2:外卖人员
    private Short newPersonType;//纠正后的人员类型
    private String personUnid;
    private Double[] standardFeature;

    /** 四代机小范围匹配 抓拍属性的字段 */
    private String channelSerialNum;
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date counttime;
    /** 四代机小范围匹配 用来匹配的字段 */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date counttimeGTE;
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date counttimeLTE;
    private List<String> channelSerialNums;
    /** 身体特征类型 0-9汉堡 10-19四代机 20-29鱼眼 */
    private Integer bodyType;
    private Set<String> gateChannelSerialnums;
    private String compareDirection;
    private String orderField;
}
