package com.viontech.keliu.model;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Getter
@Setter
@ToString
@SuppressWarnings("ALL")
public class Feature implements Serializable {
    /** 照片名称 */
    private String filename;
    /** 特征类型：人脸 face / 人体 body */
    private String type;
    /** 特征数据 */
    private List<Data> datas;
    /** 人脸roi 仅type为face时存在 */
    private List<ROI> face_roi;
    /** 有效身体roi 仅type为body时存在 */
    private List<ROI> body_roi;
    /** 得分 仅type为face时存在 */
    private Float face_score;
    /** 人脸类型 仅type为face时存在 */
    private Integer face_type;
    /** 关键点 仅type为face时存在 */
    private List<FaceKey> key_point;

}




