package com.viontech.keliu.model;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Author: 王洪波
 * @Date: 2019/6/30.
 * @Description:抓拍记录信息
 */
@Getter
@Setter
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class CaptureRecord {
    private Long captureId;//一次抓拍的唯一标识 自增id
    private String captureUnid;//一次抓拍的唯一标识
    private String personUnid;//对应的人员标识
    private Short personType;//0:顾客　1:店员  2:外卖人员
    private Double[] faceFeatures;//人脸特征
    private List<BodyFeature> bodyFeatures;//人体特征s
    private String captureTime;//"1970-11-11 11:11:11"
    private Integer duration;//单位秒
    //点位类型 01:门口1   02:门口2 03:门口3 04:门口4
    //         11:点餐处1 12:点餐处2   13:点餐处3  14:点餐处4 15:点餐处5  16:点餐处6
    //         21:取餐处1 22:取餐处2   23:取餐处3  24:取餐处4
    private Short locationType;
    private Short direction;//1为进，-1为出,0 为横穿
    private Short mood; //情绪   0-生气 1-厌恶 2-害怕 3-高兴 4-伤心 5-惊讶 6-平静
    private Short age;//年龄
    private Short gender; //性别 0:女  1：男  -1：未知
    private Short locationTypeEx;//0代表室内，1代表门口
    private Short gateId;//监控点id
}