package com.viontech.keliu.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.Date;

@Getter
@Setter
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class BodyFeature {

    /** 人体特征，最大512个double数值 */
    private Double[] feature;
    private String bid;
    private String picName;
    /**
     * 标定身体类型
     *
     * <li>汉堡0-9</li>
     * <li>四代机10-19</li>
     * <li>鱼眼20-29</li>
     * <li>默认为0</li>
     */

    private int bodyType;
    /** 四代机小范围匹配 抓拍属性的字段 */
    private String channelSerialNum;
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date counttime;
}
