/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.viontech.keliu.constant.SystemConstants;
import com.viontech.keliu.utils.JsonUtil;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.function.Consumer;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WsClient {
    private static final Logger logger = LoggerFactory.getLogger(WsClient.class);

    @OnOpen
    public void onOpen(Session session) {
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
    }

    @OnError
    public void onError(Session session, Throwable ex) {
        logger.error("session\u51fa\u73b0\u5f02\u5e38,closeReasonXX:", ex);
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        SystemConstants.THREAD_POOL.submit(() -> {
            String rid = JsonUtil.getStrParam(message, "rid");
            if (rid == null || "".equals(rid)) {
                return;
            }
            Consumer<JSONObject> consumer = AlgApiClient.rqid_consumer.get(rid);
            if (consumer == null) {
                return;
            }
            consumer.accept(JsonUtil.toObject(message));
            AlgApiClient.rqid_consumer.remove(rid);
        });
    }
}

