/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.utils;

import com.viontech.keliu.http.EBodyFormat;
import com.viontech.keliu.http.VionRequest;
import com.viontech.keliu.http.VionResponse;
import com.viontech.keliu.websocket.AlgApiClient;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public void send(String URL2, HashMap params, Consumer<JSONObject> callBack) {
        VionRequest request = new VionRequest();
        request.setReadTimeout(300000);
        request.setUri(URL2);
        request.setBody(params);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        try {
            int len = request.getBodyStr().getBytes(request.getContentEncoding()).length;
            request.addHeader("Content-Length", Integer.toString(len));
            request.addHeader("Content-Type", "application/json");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VionResponse post = this.post(request);
        String bodyStr = post.getBodyStr();
        JSONObject jo = new JSONObject(bodyStr);
        callBack.accept(jo);
        String rid = jo.getString("rid");
        Consumer<JSONObject> remove = AlgApiClient.rqid_consumer.remove(rid);
        if (remove != null) {
            log.debug("\u79fb\u9664rid\u6210\u529f:[{}]", (Object)rid);
        } else {
            log.debug("\u79fb\u9664rid\u5931\u8d25,\u5bf9\u5e94\u6570\u636e\u4e3a\u7a7a:[{}]", (Object)rid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VionResponse post(VionRequest request) {
        String charset = request.getContentEncoding();
        String content = request.getBodyStr();
        HashMap<String, String> header = request.getHeaders();
        VionResponse response = new VionResponse();
        FilterOutputStream out = null;
        InputStream is = null;
        try {
            String url = request.getParams().isEmpty() ? request.getUri().toString() : String.format("%s?%s", request.getUri().toString(), request.getParamStr());
            URL console = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)console.openConnection(Proxy.NO_PROXY);
            if (request.getConnectTimeout() != null) {
                conn.setConnectTimeout(request.getConnectTimeout());
            }
            if (request.getReadTimeout() != null) {
                conn.setReadTimeout(request.getReadTimeout());
            }
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            for (Map.Entry<String, String> vionResponse : header.entrySet()) {
                conn.setRequestProperty(vionResponse.getKey(), vionResponse.getValue());
            }
            conn.connect();
            out = new DataOutputStream(conn.getOutputStream());
            out.write(content.getBytes(charset));
            ((DataOutputStream)out).flush();
            int statusCode = conn.getResponseCode();
            response.setHeader(conn.getHeaderFields());
            response.setStatus(statusCode);
            response.setCharset(charset);
            if (statusCode != 200) {
                VionResponse vionResponse = response;
                return vionResponse;
            }
            is = conn.getInputStream();
            if (is != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                response.setBody(byteArrayOutputStream.toByteArray());
            }
            VionResponse vionResponse = response;
            return vionResponse;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return response;
    }
}

