package com.viontech.keliu.model;


import java.util.List;
import java.util.Map;


/**
 * @author 谢明辉
 * @createDate 2018-11-13
 * @description faceImage 包装类
 */

public class FaceImage {

    /** 人脸图片 */
    private String image;
    /** 目前只支持"YUV_420I","YUV_420SPUV","jpg"这三种格式 */
    private String imageFormat;
    /**
     * 图片分辨率，单位像素。如果是jpg图片，该值可以为空
     * "width":1920,
     * "height":1080
     */
    private Map<String, Integer> definition;
    /** 人脸的关键点，数组里面是float值; 如果请求中没有提供改值，则需要后台提取 */
    private List<FaceKey> faceKeys;


    public FaceImage() {
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImageFormat() {
        return imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public Map<String, Integer> getDefinition() {
        return definition;
    }

    public void setDefinition(Map<String, Integer> definition) {
        this.definition = definition;
    }

    public List<FaceKey> getFaceKeys() {
        return faceKeys;
    }

    public void setFaceKeys(List<FaceKey> faceKeys) {
        this.faceKeys = faceKeys;
    }
}
