package com.viontech.keliu.model;

import java.util.List;

/**
 * @Author: 王洪波
 * @Date: 2019/6/30.
 * @Description:抓拍记录信息
 */
public class CaptureRecord {
    private Long captureId;//一次抓拍的唯一标识 自增id
    private String captureUnid;//一次抓拍的唯一标识
    private String personUnid;//对应的人员标识
    private Short personType;//0:顾客　1:店员  2:外卖人员
    private Double[] faceFeatures;//人脸特征
    private List<BodyFeature> bodyFeatures;//人体特征s
    private String captureTime;//"1970-11-11 11:11:11"
    private Integer duration;//单位秒
    //点位类型 01:门口1   02:门口2 03:门口3 04:门口4
    //         11:点餐处1 12:点餐处2   13:点餐处3  14:点餐处4 15:点餐处5  16:点餐处6
    //         21:取餐处1 22:取餐处2   23:取餐处3  24:取餐处4
    private Short locationType;
    private Short direction;//1为进，-1为出,0 为横穿
    private Short mood; //情绪   0-生气 1-厌恶 2-害怕 3-高兴 4-伤心 5-惊讶 6-平静
    private Short age;//年龄
    private Short gender; //性别 0:女  1：男  -1：未知
    private Short locationTypeEx;//0代表室内，1代表门口
    private Short gateId;//监控点id
    public Long getCaptureId() {
        return captureId;
    }
    public void setCaptureId(Long captureId) {
        this.captureId = captureId;
    }
    public Short getLocationTypeEx() {
        return locationTypeEx;
    }
    public void setLocationTypeEx(Short locationTypeEx) {
        this.locationTypeEx = locationTypeEx;
    }
    public Short getGateId() {
        return gateId;
    }
    public void setGateId(Short gateId) {
        this.gateId = gateId;
    }
    public String getCaptureUnid() {
        return captureUnid;
    }
    public void setCaptureUnid(String captureUnid) {
        this.captureUnid = captureUnid;
    }
    public String getPersonUnid() {
        return personUnid;
    }
    public void setPersonUnid(String personUnid) {
        this.personUnid = personUnid;
    }
    public Short getPersonType() {
        return personType;
    }
    public void setPersonType(Short personType) {
        this.personType = personType;
    }
    public Double[] getFaceFeatures() {
        return faceFeatures;
    }
    public void setFaceFeatures(Double[] faceFeatures) {
        this.faceFeatures = faceFeatures;
    }
    public List<BodyFeature> getBodyFeatures() {
        return bodyFeatures;
    }
    public void setBodyFeatures(List<BodyFeature> bodyFeatures) {
        this.bodyFeatures = bodyFeatures;
    }
    public String getCaptureTime() {
        return captureTime;
    }
    public void setCaptureTime(String captureTime) {
        this.captureTime = captureTime;
    }
    public Integer getDuration() {
        return duration;
    }
    public void setDuration(Integer duration) {
        this.duration = duration;
    }
    public Short getLocationType() {
        return locationType;
    }
    public void setLocationType(Short locationType) {
        this.locationType = locationType;
    }
    public Short getDirection() {
        return direction;
    }
    public void setDirection(Short direction) {
        this.direction = direction;
    }
    public Short getMood() {
        return mood;
    }
    public void setMood(Short mood) {
        this.mood = mood;
    }
    public Short getAge() {
        return age;
    }
    public void setAge(Short age) {
        this.age = age;
    }
    public Short getGender() {
        return gender;
    }
    public void setGender(Short gender) {
        this.gender = gender;
    }
}