package com.viontech.keliu.application;


import com.viontech.keliu.websocket.AlgApiClient;
import org.apache.tomcat.util.codec.binary.Base64;
import org.json.JSONObject;

import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.CompletableFuture;


/**
 * @author 谢明辉
 * @createDate 2018-11-23
 * @description
 */

public class Test {

    public static void main(String[] args) throws Exception {
//        main2();
        main1();
    }

    static byte[] bufferedImage2Bytes(BufferedImage image) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam param = imageWriter.getDefaultWriteParam();
        param.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
        param.setCompressionQuality(1.0F);
        try {
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(image);

        } finally {
            imageWriter.dispose();
            imageOutputStream.flush();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void main1() throws Exception {
        AlgApiClient client = new AlgApiClient("http://101.200.130.13:10000");
        try (FileInputStream fis
                     = new FileInputStream("C:\\Users\\vion\\Desktop\\a69157ff-784f-44a1-98c6-156319b9b3ef.jpg")) {
            BufferedImage image = ImageIO.read(fis);
            byte[] bytes = bufferedImage2Bytes(image);
            String s = Base64.encodeBase64String(bytes);
            HashMap<String, Object> map = new HashMap<>(1);
            map.put("needFaceCheck", 1);
            CompletableFuture<JSONObject> featureAndAttr = client.getFeatureAndAttr(s, "face", AlgApiClient.IMAGE_FORMAT_JPG, Collections.emptyList(), map);
            JSONObject jsonObject = featureAndAttr.get();
            String s1 = jsonObject.toString();
            System.out.println(s1);
            System.exit(0);
        }
    }

    public static void main2() throws Exception {
        AlgApiClient client = new AlgApiClient("ws://192.168.9.116:10080");
//        AlgApiClient client = new AlgApiClient("ws://101.200.130.13:10080");
        List<File> pics = new ArrayList<>();
        File root = new File("C:\\Users\\vion\\Desktop\\20201110");
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                File[] files1 = file.listFiles();
                if (files1 != null) {
                    pics.addAll(Arrays.asList(files1));
                }
            }
        }
        HashSet<String> errors = new HashSet<>();
        for (File pic : pics) {
            try (FileInputStream fis = new FileInputStream(pic)) {
                System.out.println(pic.getPath());

                BufferedImage image = ImageIO.read(fis);
                byte[] bytes = bufferedImage2Bytes(image);
                String s = Base64.encodeBase64String(bytes);
                HashMap<String, Object> map = new HashMap<>(1);
                map.put("needFaceCheck", 1);
                CompletableFuture<JSONObject> featureAndAttr = client.getFeatureAndAttr(s, "face", AlgApiClient.IMAGE_FORMAT_JPG, Collections.emptyList(), map);
                JSONObject jsonObject = featureAndAttr.get();
                int success = jsonObject.getInt("success");
                if (1 == success) {
                    continue;
                }
                String description = jsonObject.getString("description");
                System.out.println(description);
                errors.add(description);
            }
        }
        System.out.println(errors.toString());
    }
}
