package com.viontech.keliu.websocket;


import com.viontech.keliu.utils.JsonUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.websocket.*;
import java.util.function.Consumer;


@ClientEndpoint
public class WsClient{
	
	private static final Logger logger = LoggerFactory.getLogger(WsClient.class);

	@OnOpen
	public void onOpen(Session session) {
//		logger.error("session开启,id:"+session.getId());
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		//关闭信息
//		logger.error("session关闭,id:"+session.getId());
//		logger.error("session关闭,closeReason:"+closeReason.toString());
	}
	@OnError
	public void onError(Session session, Throwable ex){
		ex.printStackTrace();
		logger.error("session出现异常,closeReason:",ex);
	}
	@OnMessage
    public void onMessage(Session session, String message) {
//		logger.info("收到消息{}",message);
    		new Thread(()->{
				String rid = JsonUtil.getStrParam(message, "rid");
				if(rid == null || rid == ""){
					return;
				}

				Consumer<JSONObject> consumer = AlgApiClient.rqid_consumer.get(rid);
				if(consumer == null){
					return;
				}
				consumer.accept(JsonUtil.toObject(message));
				AlgApiClient.rqid_consumer.remove(rid);
			}).start();
    }

}
