package com.viontech.keliu.utils;


import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
	
	public static String toStr(Object obj){
		if(obj == null)
			return null;
		return JSONObject.valueToString(obj);
	}
	
	public static JSONObject toObject(Object obj){
		if(obj == null)
			return null;
		return new JSONObject(obj);
	}
	public static JSONObject toObject(String obj){
		if(obj == null)
			return null;
		return new JSONObject(obj);
	}
	
	
	public static JSONArray toArray(Object json){
		if(json == null)
			return null;
		JSONArray array = new JSONArray(json);
		return array;
	}
	public static JSONArray toArray(String json){
		if(json == null)
			return null;
		JSONArray array = new JSONArray(json);
		return array;
	}
	
	

	
	public static String getStrParam(Object json, String key){
		if(json == null || key == null || key == "")
			return null;
		JSONObject jsonObject = null;
		try {
			jsonObject = new JSONObject(json);
			return jsonObject.getString(key);
		}catch(JSONException e){
			if(e.getMessage().contains("begin with '{'"))
				return e.getMessage();
			return null;
		}
	}
	public static String getStrParam(String json, String key){
		if(json == null || key == null || key == "")
			return null;
		JSONObject jsonObject = null;
		try {
			jsonObject = new JSONObject(json);
			return jsonObject.getString(key);
		}catch(JSONException e){
			if(e.getMessage().contains("begin with '{'"))
				return e.getMessage();
			return null;
		}
	}
	
	public static Object getObjParam(JSONObject jsonObject, String key)
			throws JSONException {
		try {
			return jsonObject.get(key);
		
		}catch (Exception e) {
			return null;
		}
	}
	
	public static Object getObjParam(Object obj, String key)
			throws JSONException {
		JSONObject jsonObject = null;
		if(obj instanceof JSONObject){
			jsonObject = (JSONObject)obj;
		}else{
			try {
				jsonObject = new JSONObject(obj);
			}catch(JSONException e){
				if(e.getMessage().contains("begin with '{'"))
					return e.getMessage();
				return null;
			}
		}
		return JsonUtil.getObjParam(jsonObject, key);
	}
	public static Object getObjParam(String obj, String key)
			throws JSONException {
		JSONObject jsonObject = null;
		try {
			jsonObject = new JSONObject(obj);
		}catch(JSONException e){
			if(e.getMessage().contains("begin with '{'"))
				return e.getMessage();
			return null;
		}
		return JsonUtil.getObjParam(jsonObject, key);
	}
	
	/**
	 * 向jsonObject中put键值，存在及修改
	 * @param jsonObject
	 * @param key
	 * @param val
	 * @return
	 * @throws JSONException
	 */
	public static JSONObject put(JSONObject jsonObject, Object key, Object val) throws JSONException {
		if(key ==null)
			return jsonObject;
		jsonObject.put(key.toString(), val);
		return jsonObject;
	}
	
	
	public static boolean arrayIsEmpty(JSONArray array){
		if(array == null || array.length() == 0)
			return true;
		return false;
	}
	
	public static boolean arrayIsNotEmpty(JSONArray array){
		if(array == null || array.length() == 0)
			return false;
		return true;
	}
}
