package com.viontech.keliu.utils;

import com.viontech.keliu.http.*;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class HttpUtil {

    public static void send(String URL, HashMap params, Consumer<JSONObject> callBack){
        VionRequest request = new VionRequest();
        request.setReadTimeout(1000*60*5);
        request.setUri(URL);
        request.setBody(params);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        try {
            int len = request.getBodyStr().getBytes(request.getContentEncoding()).length;
            request.addHeader(Headers.CONTENT_LENGTH, Integer.toString(len));
            request.addHeader(Headers.CONTENT_TYPE, HttpContentType.JSON_DATA);
        } catch (Exception e) {
            e.printStackTrace();
        }
        VionResponse post = VionHttpClient.post(request);
        JSONObject jo = new JSONObject(post.getBodyStr());
        callBack.accept(jo);
    }
}
