/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.viontech.keliu.websocket.WsClient;
import java.io.IOException;
import java.net.URI;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class WsClientFacetory {
    private String urL = null;
    private URI uri;
    private Session session;
    private WebSocketContainer container;

    public void setUrl(String urL) {
        this.urL = urL;
    }

    public synchronized void send(String text) throws IOException, DeploymentException {
        if (text == null || text == "") {
            return;
        }
        Session session = this.createConnect();
        session.getBasicRemote().sendText(text);
    }

    private Session createConnect() throws DeploymentException, IOException {
        return this.getSession();
    }

    private URI getUri() {
        if (this.uri == null) {
            this.uri = URI.create(this.urL);
        }
        return this.uri;
    }

    private synchronized Session getSession() throws DeploymentException, IOException {
        if (this.session == null || !this.session.isOpen()) {
            this.session = this.getContainer().connectToServer(WsClient.class, this.getUri());
            this.session.setMaxTextMessageBufferSize(1024000);
        }
        return this.session;
    }

    private WebSocketContainer getContainer() {
        if (this.container == null) {
            this.container = ContainerProvider.getWebSocketContainer();
        }
        return this.container;
    }
}

