/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.FaceKey;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.model.ROI;
import com.viontech.keliu.utils.HttpUtil;
import com.viontech.keliu.utils.JsonUtil;
import com.viontech.keliu.utils.UUIDUtil;
import com.viontech.keliu.utils.Util;
import com.viontech.keliu.websocket.WsClientFacetory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.websocket.DeploymentException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgApiClient {
    Logger log = LoggerFactory.getLogger(AlgApiClient.class);
    public static final String VENDOR_VION = "vion";
    public static final String VENDOR_BAIDU = "baidu";
    public static final String IMAGE_FORMAT_YUV_420I = "YUV_420I";
    public static final String IMAGE_FORMAT_YUV_420SPUV = "YUV_420SPUV";
    public static final String IMAGE_FORMAT_JPG = "jpg";
    public static final String IMAGE_TYPE_FACE = "face";
    public static final String IMAGE_TYPE_BODY = "body";
    public static final long API_REQUEST_TIME_OUT = 30000L;
    public Boolean httpFlag = false;
    public static String urlInfo = "";
    public static Map<String, Consumer<JSONObject>> rqid_consumer = new HashMap<String, Consumer<JSONObject>>();
    private WsClientFacetory wsClientFacetory;

    public AlgApiClient(String url) {
        if (url != null && url.contains("http")) {
            this.httpFlag = true;
            urlInfo = url;
        } else {
            this.httpFlag = false;
            this.wsClientFacetory = new WsClientFacetory();
            this.wsClientFacetory.setUrl(url);
        }
    }

    private Map<String, Object> getParams(String command, Consumer<JSONObject> callBack) {
        String rid = UUIDUtil.getUUID32();
        rqid_consumer.put(rid, callBack);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", command);
        params.put("rid", rid);
        return params;
    }

    public CompletableFuture<JSONObject> getFeatureAndAttr(String image, String imageType, String imageFormat, List<FaceKey> faceKeys, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        Integer integer;
        if (image == null || image == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010image\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (imageType == null || imageType == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010imageType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (imageFormat == null || imageFormat == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010imageFormat\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IMAGE_TYPE_BODY.equals(imageType) && (options == null || options.get("body_roi") == null)) {
            throw new ParameterExceptin("\u5f53ImageType\u4e3aface\u65f6\uff0coptions\u4e2d\u5fc5\u987b\u5305\u542b\u5c5e\u6027\u3010body_roi\u3011");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("GetFeatureAndAttr", callBack);
        if (!IMAGE_FORMAT_JPG.equals(imageFormat)) {
            Object image_width = options.get("image_width");
            if (image_width == null) {
                throw new ParameterExceptin("\u5b57\u6bb5\u3010image_width\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Object image_height = options.get("image_height");
            if (image_height == null) {
                throw new ParameterExceptin("\u5b57\u6bb5\u3010image_height\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, Object> definition = new HashMap<String, Object>();
            definition.put("width", image_width);
            definition.put("height", image_height);
            params.put("definition", definition);
        }
        String vendor = VENDOR_VION;
        if (options != null && options.get("vendor") != null) {
            vendor = String.valueOf(options.get("vendor"));
        }
        if (options != null && options.get("body_roi") != null) {
            ROI roi = (ROI)options.get("body_roi");
            params.put("bodyROI", roi);
        }
        if (options != null && options.get("needFaceCheck") != null && (integer = (Integer)options.get("needFaceCheck")) == 1) {
            params.put("needFaceCheck", integer);
        }
        params.put("vendor", vendor);
        params.put("image", image);
        params.put("imageType", imageType);
        params.put("imageFormat", imageFormat);
        if (faceKeys != null) {
            float[] faceKeyArr = new float[faceKeys.size() * 2];
            int index = 0;
            for (int i = 0; i < faceKeys.size(); ++i) {
                faceKeyArr[index++] = faceKeys.get(i).getX();
                faceKeyArr[index++] = faceKeys.get(i).getY();
            }
            params.put("faceKeys", faceKeyArr);
        }
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> getFaceFeatureBatch(List<String> images, String imageFormat, List<List<FaceKey>> faceKeyLists, List<Map<String, Object>> optionsList) throws ParameterExceptin, IOException, DeploymentException {
        if (Util.isEmpty(imageFormat)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010imageFormat\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (images.size() != faceKeyLists.size()) {
            throw new ParameterExceptin("\u53c2\u6570\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        boolean definitionFlag = false;
        if (!IMAGE_FORMAT_JPG.equals(imageFormat)) {
            definitionFlag = true;
            if (images.size() != optionsList.size()) {
                throw new ParameterExceptin("\u53c2\u6570\u957f\u5ea6\u4e0d\u6b63\u786e");
            }
        }
        ArrayList faceImages = new ArrayList();
        for (int i = 0; i < images.size(); ++i) {
            HashMap<String, Object> faceImage = new HashMap<String, Object>(4);
            if (Util.isEmpty(images.get(i))) {
                throw new ParameterExceptin("\u5b57\u6bb5\u3010image\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            faceImage.put("image", images.get(i));
            faceImage.put("imageFormat", imageFormat);
            if (definitionFlag) {
                Object imageWidth = optionsList.get(i).get("image_width");
                Object imageHeight = optionsList.get(i).get("image_height");
                if (imageWidth == null || imageHeight == null) {
                    throw new ParameterExceptin("\u5b57\u6bb5\u3010image_width\u3011\u6216\u3010image_height\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                HashMap<String, Object> definition = new HashMap<String, Object>(2);
                definition.put("width", imageWidth);
                definition.put("height", imageHeight);
                faceImage.put("definition", definition);
            }
            if (faceKeyLists.get(i) != null) {
                float[] faceKeyArr = new float[faceKeyLists.get(i).size() * 2];
                int index = 0;
                for (int j = 0; j < faceKeyLists.get(i).size(); ++j) {
                    faceKeyArr[index++] = faceKeyLists.get(i).get(j).getX();
                    faceKeyArr[index++] = faceKeyLists.get(i).get(j).getY();
                }
                faceImage.put("faceKeys", faceKeyArr);
            }
            faceImages.add(faceImage);
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("GetFaceFeatureBatch", callBack);
        params.put("vendor", VENDOR_VION);
        params.put("faceImages", faceImages);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> getInTime(List<BodyFeature> bodyFeatures, String outTime, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (bodyFeatures == null || bodyFeatures.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010bodyFeatures\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (outTime == null || outTime == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010outTime\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPoolId == null || "".equals(personPoolId)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u4e0d\u80fd\u4e3a\u7a7a\u3011");
        }
        if (personPool == null) {
            personPool = new ArrayList<Person>();
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("GetInTime", callBack);
        params.put("bodyFeatures", bodyFeatures);
        params.put("outTime", outTime);
        params.put("personPool", personPool);
        params.put("personPoolId", personPoolId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> getAbnormalPerson(String curTime, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (curTime == null || curTime == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010curTime\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPoolId == null || "".equals(personPoolId)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("GetAbnormalPerson", callBack);
        params.put("curTime", curTime);
        params.put("personPool", personPool);
        params.put("personPoolId", personPoolId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> addPersonPool(String poolId, int poolType, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("AddPersonPool", callBack);
        params.put("poolId", poolId);
        params.put("poolType", poolType);
        if (personPool != null || personPool.size() > 0) {
            params.put("personPool", personPool);
        }
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> delPersonPool(int flushPool, String poolId, List<Person> personIds, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("DelPersonPool", callBack);
        params.put("flushPool", flushPool);
        params.put("poolId", poolId);
        params.put("personIds", personIds);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> queryPersonPool(int listAll, String poolId, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("QueryPersonPool", callBack);
        params.put("listAll", listAll);
        params.put("poolId", poolId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> modifyPersonPool(String poolId, int poolType, int updateType, List<Person> personPool, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPool == null || personPool.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPool\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("ModifyPersonPool", callBack);
        params.put("poolId", poolId);
        params.put("poolType", poolType);
        params.put("updateType", updateType);
        params.put("personPool", personPool);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> matchPerson(int personType, Person person, String personPoolId, List<Person> personPool, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPoolId == null || personPoolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("MatchPerson", callBack);
        params.put("personType", personType);
        params.put("person", person);
        params.put("personPoolId", personPoolId);
        params.put("personPool", personPool);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> matchHistoryPerson(int personType, Person person, List<String> unionPersonPoolId, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (unionPersonPoolId == null || unionPersonPoolId.size() <= 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010unionPersonPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u6ca1\u6709\u6c60\u540d\u79f0");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("MatchPerson", callBack);
        params.put("personType", personType);
        params.put("person", person);
        params.put("unionPersonPoolId", unionPersonPoolId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> updatePerson(int personType, Person person, FaceFeature newFaceFeature, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (newFaceFeature == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010newFaceFeature\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("UpdatePerson", callBack);
        params.put("personType", personType);
        params.put("person", person);
        params.put("newFaceFeature", newFaceFeature);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> verifyPerson(int personType, Person person, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("VerifyPerson", callBack);
        params.put("personType", personType);
        params.put("person", person);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> clusterPerson(int personType, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (personPoolId == null || personPoolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPool == null || personPool.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPool\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("ClusterPerson", callBack);
        params.put("personType", personType);
        params.put("personPoolId", personPoolId);
        params.put("personPool", personPool);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> verifyPersonPool(int personType, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (personPoolId == null || personPoolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPool == null || personPool.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPool\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("VerifyPersonPool", callBack);
        params.put("personType", personType);
        params.put("personPoolId", personPoolId);
        params.put("personPool", personPool);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<JSONObject> getMotionTrack(List<Person> motionPoints, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (motionPoints == null || motionPoints.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010motionPoints\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<JSONObject> completableFuture = new CompletableFuture<JSONObject>();
        Consumer<JSONObject> callBack = item -> completableFuture.complete((JSONObject)item);
        Map<String, Object> params = this.getParams("GetMotionTrack", callBack);
        params.put("motionPoints", motionPoints);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    private void httpOrWebSocketSend(Consumer<JSONObject> callBack, Map<String, Object> params) throws IOException, DeploymentException {
        if (this.httpFlag.booleanValue()) {
            HashMap hashMap = (HashMap)params;
            HttpUtil.send(urlInfo, hashMap, callBack);
        } else {
            this.wsClientFacetory.send(JsonUtil.toStr(params));
        }
    }
}

