package com.viontech.match.util;

import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;

/**
 * .
 *
 * @author 谢明辉
 * @version 0.0.1
 */
@Slf4j
@SuppressWarnings("ALL")
public class Utils {

    /**
     * 将 2110 维的人体特征加权计算得到 2048 维特征数据
     *
     * @param f1 2110 维的人体特征数据
     *
     * @return 加权计算后的结果
     */
    public static Double[] transferBodyFeature(Double[] f1) {
        try {
            int featureLen = f1[0].intValue();
            int npiece = f1[1].intValue();
            Double[] vec1 = Arrays.copyOfRange(f1, 3, 2048 + 3);
            Double[] temp = Arrays.copyOfRange(f1, 3 + featureLen + npiece, f1.length);
            Double[] wt1 = getWeights(temp);
            Double normCoeF1 = 0D;
            for (int i = 0; i < 8; i++) {
                normCoeF1 += wt1[i] * wt1[i] * f1[3 + 2048 + i];
            }
            normCoeF1 = 1 / Math.sqrt(normCoeF1);

            for (int i = 0; i < 2048; i++) {
                vec1[i] = vec1[i] * wt1[i / 256] * normCoeF1;
            }

            return vec1;
        } catch (Throwable e) {
            log.error("转换出错", e);
        }
        return f1;
    }

    private static Double[] getWeights(Double[] landmarks) {
        Double[] wt = new Double[8];
        Arrays.fill(wt, 1D);

        if (landmarks[15 * 3 + 2] > 0.8 && landmarks[16 * 3 + 2] > 0.8) {
        } else if (landmarks[15 * 3 + 2] > 0.8 || landmarks[16 * 3 + 2] > 0.8) {
            wt[7] = 0.7;
        } else if (landmarks[13 * 3 + 2] > 0.8 && landmarks[14 * 3 + 2] > 0.8) {
            wt[7] = 0.2;
            wt[3] = 0.7;
        } else if (landmarks[13 * 3 + 2] > 0.8 || landmarks[14 * 3 + 2] > 0.8) {
            wt[7] = 0.1;
            wt[3] = 0.4;
        } else if (landmarks[11 * 3 + 2] > 0.7 && landmarks[12 * 3 + 2] > 0.7) {
            wt[7] = 0D;
            wt[3] = 0.2;
            wt[6] = 0.8;
            wt[2] = 1.1;
            wt[5] = 1.1;
        } else {
            wt[7] = 0D;
            wt[3] = 0D;
            wt[6] = 0.3;
            wt[2] = 1.2;
            wt[5] = 1.4;
        }
        return wt;
    }

}
