package com.viontech.match.entity.vo;

import com.viontech.keliu.model.Person;
import com.viontech.keliu.model.Pool;
import com.viontech.match.entity.PoolInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * .
 *
 * @author 谢明辉
 * @version 0.0.1
 */

@Getter
@Setter
@ToString
public class ResponseVo {

    private Integer success;
    private String description;
    private String rid;
    private Integer errCode;

    private List<Pool> personPoolStatus;
    private Integer oper;
    private Integer index;
    private Integer match;
    private List<PoolInfo> poolIds;
    private List<Person> matchPersons;
    private List<Person> matchBodies;

    public ResponseVo(String rid) {
        this.rid = rid;
    }

    public static ResponseVo commandNotFound(String rid) {
        return error(rid, "command not found");
    }

    public static ResponseVo error(String rid, String description) {
        return error(rid, 1, description);
    }

    public static ResponseVo error(String rid, Integer errCode, String description) {
        ResponseVo responseVo = new ResponseVo(rid);
        responseVo.setSuccess(0);
        responseVo.setErrCode(errCode);
        responseVo.setDescription(description);
        return responseVo;
    }

    public static ResponseVo success(String rid) {
        return success(rid, "success");
    }

    public static ResponseVo success(String rid, String description) {
        ResponseVo responseVo = new ResponseVo(rid);
        responseVo.setSuccess(1);
        responseVo.setDescription(description);
        responseVo.setErrCode(0);
        return responseVo;
    }

    public static ResponseVo poolIdNotExists(String rid) {
        return ResponseVo.error(rid, 4, "poolId not exists");
    }
}
