package com.viontech.match.controller;

import com.viontech.match.entity.vo.RequestVo;
import com.viontech.match.entity.vo.ResponseVo;
import com.viontech.match.service.PersonService;
import com.viontech.match.service.PoolService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * .
 *
 * @author 谢明辉
 * @version 0.0.1
 */
@RestController
@RequestMapping("/alg")
@Slf4j
public class MainController {

    @Resource
    private PersonService personService;
    @Resource
    private PoolService poolService;

    @PostMapping
    public ResponseVo all(@RequestBody RequestVo requestVo) throws Exception {
        String rid = requestVo.getRid();
        try {
            switch (requestVo.getCommand()) {
                case AddPersonPool:
                    return poolService.createPool(requestVo);
                case DelPersonPool:
                    return poolService.deletePool(requestVo);
                case ModifyPersonPool:
                    return poolService.modifyPool(requestVo);
                case QueryPersonPool:
                    return poolService.queryPool(requestVo);
                case MatchPerson:
                    return personService.matchPerson(requestVo);
                case UpdatePerson:
                    return personService.updatePerson(requestVo);
                default:
                    return ResponseVo.commandNotFound(rid);
            }
        } catch (Exception e) {
            log.error("", e);
            return ResponseVo.error(rid, e.getMessage());
        }
    }

    @GetMapping("/pools")
    public Object getPools() {
        try {
            return poolService.queryPoolInfo(null);
        } catch (IOException e) {
            return ResponseVo.error("error", e.getMessage());
        }
    }
}
