/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.ArrayList;
import kafka.common.TopicAndPartition;
import kafka.utils.Json$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ZkUtils$ {
    public static final ZkUtils$ MODULE$;
    private final ArrayList<ACL> kafka$utils$ZkUtils$$UseDefaultAcls;
    private final String AdminPath;
    private final String BrokersPath;
    private final String ClusterPath;
    private final String ConfigPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String IsrChangeNotificationPath;
    private final String KafkaAclPath;
    private final String KafkaAclChangesPath;
    private final String ConsumersPath;
    private final String ClusterIdPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String BrokerSequenceIdPath;
    private final String ConfigChangesPath;
    private final String ConfigUsersPath;
    private final String ProducerIdBlockPath;
    private final Seq<String> SecureZkRootPaths;
    private final Seq<String> SensitiveZkRootPaths;

    static {
        new ZkUtils$();
    }

    public ArrayList<ACL> kafka$utils$ZkUtils$$UseDefaultAcls() {
        return this.kafka$utils$ZkUtils$$UseDefaultAcls;
    }

    public String AdminPath() {
        return this.AdminPath;
    }

    public String BrokersPath() {
        return this.BrokersPath;
    }

    public String ClusterPath() {
        return this.ClusterPath;
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String IsrChangeNotificationPath() {
        return this.IsrChangeNotificationPath;
    }

    public String KafkaAclPath() {
        return this.KafkaAclPath;
    }

    public String KafkaAclChangesPath() {
        return this.KafkaAclChangesPath;
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String ClusterIdPath() {
        return this.ClusterIdPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String BrokerSequenceIdPath() {
        return this.BrokerSequenceIdPath;
    }

    public String ConfigChangesPath() {
        return this.ConfigChangesPath;
    }

    public String ConfigUsersPath() {
        return this.ConfigUsersPath;
    }

    public String ProducerIdBlockPath() {
        return this.ProducerIdBlockPath;
    }

    public Seq<String> SecureZkRootPaths() {
        return this.SecureZkRootPaths;
    }

    public Seq<String> SensitiveZkRootPaths() {
        return this.SensitiveZkRootPaths;
    }

    public ZkUtils apply(String zkUrl, int sessionTimeout, int connectionTimeout, boolean isZkSecurityEnabled) {
        Tuple2<ZkClient, ZkConnection> tuple2 = this.createZkClientAndConnection(zkUrl, sessionTimeout, connectionTimeout);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ZkClient zkClient = (ZkClient)tuple2._1();
            ZkConnection zkConnection = (ZkConnection)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)zkClient, (Object)zkConnection);
            ZkClient zkClient2 = (ZkClient)tuple23._1();
            ZkConnection zkConnection2 = (ZkConnection)tuple23._2();
            return new ZkUtils(zkClient2, zkConnection2, isZkSecurityEnabled);
        }
        throw new MatchError(tuple2);
    }

    public ZkUtils apply(ZkClient zkClient, boolean isZkSecurityEnabled) {
        return new ZkUtils(zkClient, null, isZkSecurityEnabled);
    }

    public ZkClient createZkClient(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkClient zkClient = new ZkClient(zkUrl, sessionTimeout, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        zkClient.addAuthInfo("krbgroup", null);
        return zkClient;
    }

    public Tuple2<ZkClient, ZkConnection> createZkClientAndConnection(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkConnection zkConnection = new ZkConnection(zkUrl, sessionTimeout);
        ZkClient zkClient = new ZkClient((IZkConnection)zkConnection, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        zkClient.addAuthInfo("krbgroup", null);
        return new Tuple2((Object)zkClient, (Object)zkConnection);
    }

    public boolean sensitivePath(String path) {
        return path != null && this.SensitiveZkRootPaths().exists((Function1)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$6;

            public final boolean apply(String x$2) {
                return this.path$6.startsWith(x$2);
            }
            {
                this.path$6 = path$6;
            }
        });
    }

    public java.util.List<ACL> DefaultAcls(boolean isSecure) {
        return this.defaultAcls(isSecure, "");
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<ACL> defaultAcls(boolean isSecure, String path) {
        ArrayList arrayList;
        if (isSecure) {
            void var3_3;
            ArrayList<ACL> list = new ArrayList<ACL>();
            list.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            Object object = this.sensitivePath(path) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)list.addAll(ZooDefs.Ids.READ_ACL_UNSAFE));
            list.add(new ACL(31, new Id("krbgroup", "kafkaadmin")));
            list.add(new ACL(31, new Id("krbgroup", "System_administrator_186")));
            arrayList = var3_3;
        } else {
            arrayList = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        return arrayList;
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = this.createZkClient(zkUrl, 30000, 30000);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public String getEntityConfigRootPath(String entityType) {
        return new StringBuilder().append((Object)this.ConfigPath()).append((Object)"/").append((Object)entityType).toString();
    }

    public String getEntityConfigPath(String entityType, String entity) {
        return new StringBuilder().append((Object)this.getEntityConfigRootPath(entityType)).append((Object)"/").append((Object)entity).toString();
    }

    public String getEntityConfigPath(String entityPath) {
        return new StringBuilder().append((Object)this.ConfigPath()).append((Object)"/").append((Object)entityPath).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public Seq<Tuple2<TopicAndPartition, Seq<Object>>> parsePartitionReassignmentDataWithoutDedup(String jsonData) {
        Option<Object> option;
        block7: {
            Seq seq;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        Seq seq2;
                        block4: {
                            block3: {
                                option = Json$.MODULE$.parseFull(jsonData);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object m = some.x();
                                option2 = ((Map)m).get((Object)"partitions");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object partitionsSeq = some2.x();
                                seq2 = (Seq)((Seq)partitionsSeq).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<TopicAndPartition, Seq<Object>> apply(Map<String, Object> p) {
                                        String topic = (String)p.get((Object)"topic").get();
                                        int partition = BoxesRunTime.unboxToInt((Object)p.get((Object)"partition").get());
                                        Seq newReplicas = (Seq)p.get((Object)"replicas").get();
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, partition)), (Object)newReplicas);
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block4;
                            }
                            if (!None$.MODULE$.equals(option2)) break block5;
                            seq2 = (Seq)Seq$.MODULE$.empty();
                        }
                        seq = seq2;
                        break block6;
                    }
                    throw new MatchError((Object)option2);
                }
                if (!None$.MODULE$.equals(option)) break block7;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        return this.parsePartitionReassignmentDataWithoutDedup(jsonData).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<Object> option;
        block7: {
            ObjectRef topics;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        block4: {
                            block3: {
                                topics = ObjectRef.create((Object)List$.MODULE$.empty());
                                option = Json$.MODULE$.parseFull(jsonData);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object m = some.x();
                                option2 = ((Map)m).get((Object)"topics");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object partitionsSeq = some2.x();
                                Seq mapPartitionSeq = (Seq)partitionsSeq;
                                mapPartitionSeq.foreach((Function1)new Serializable(topics){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef topics$1;

                                    public final void apply(Map<String, Object> p) {
                                        String topic = (String)p.get((Object)"topic").get();
                                        this.topics$1.elem = (List)((List)this.topics$1.elem).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), List$.MODULE$.canBuildFrom());
                                    }
                                    {
                                        this.topics$1 = topics$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!None$.MODULE$.equals(option2)) break block5;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    throw new MatchError((Object)option2);
                }
                if (!None$.MODULE$.equals(option)) break block7;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return (List)topics.elem;
        }
        throw new MatchError(option);
    }

    public String controllerZkData(int brokerId, long timestamp2) {
        return Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokerid"), (Object)BoxesRunTime.boxToInteger((int)brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)((Object)BoxesRunTime.boxToLong((long)timestamp2)).toString())})));
    }

    public String preferredReplicaLeaderElectionZkData(Set<TopicAndPartition> partitions) {
        return Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitions.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(TopicAndPartition tp) {
                return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition()))}));
            }
        }, Set$.MODULE$.canBuildFrom()))})));
    }

    public String formatAsReassignmentJson(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    if (topicAndPartition != null) {
                        String topic = topicAndPartition.topic();
                        int partition = topicAndPartition.partition();
                        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)partition)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), (Object)replicas)}));
                        return map;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    private ZkUtils$() {
        MODULE$ = this;
        this.kafka$utils$ZkUtils$$UseDefaultAcls = new ArrayList();
        this.AdminPath = "/admin";
        this.BrokersPath = "/brokers";
        this.ClusterPath = "/cluster";
        this.ConfigPath = "/config";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.IsrChangeNotificationPath = "/isr_change_notification";
        this.KafkaAclPath = "/kafka-acl";
        this.KafkaAclChangesPath = "/kafka-acl-changes";
        this.ConsumersPath = "/consumers";
        this.ClusterIdPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ClusterPath()}));
        this.BrokerIdsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/ids"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BrokersPath()}));
        this.BrokerTopicsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/topics"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BrokersPath()}));
        this.ReassignPartitionsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/reassign_partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.AdminPath()}));
        this.DeleteTopicsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/delete_topics"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.AdminPath()}));
        this.PreferredReplicaLeaderElectionPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/preferred_replica_election"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.AdminPath()}));
        this.BrokerSequenceIdPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/seqid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BrokersPath()}));
        this.ConfigChangesPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/changes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ConfigPath()}));
        this.ConfigUsersPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/users"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ConfigPath()}));
        this.ProducerIdBlockPath = "/latest_producer_id_block";
        this.SecureZkRootPaths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.AdminPath(), this.BrokersPath(), this.ClusterPath(), this.ConfigPath(), this.ControllerPath(), this.ControllerEpochPath(), this.IsrChangeNotificationPath(), this.KafkaAclPath(), this.KafkaAclChangesPath(), this.ProducerIdBlockPath()}));
        this.SensitiveZkRootPaths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConfigUsersPath()}));
    }
}

