/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u000f\tI2\t\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\u0002C\u0007\u0001\u0005\u000b\u0007I\u0011\u0002\b\u0002\r\r|gNZ5h+\u0005y\u0001CA\u0005\u0011\u0013\t\t\"A\u0001\rDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u00148i\u001c8gS\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006IaD\u0001\bG>tg-[4!\u0011!)\u0002A!b\u0001\n\u00131\u0012aB7fiJL7m]\u000b\u0002/A\u0011\u0001$I\u0007\u00023)\u0011QC\u0007\u0006\u00037q\taaY8n[>t'BA\u0003\u001e\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\n\u0005\tJ\"aB'fiJL7m\u001d\u0005\tI\u0001\u0011\t\u0011)A\u0005/\u0005AQ.\u001a;sS\u000e\u001c\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0003(\u0003\u0011!\u0018.\\3\u0016\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00055R#\u0001\u0002+j[\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006i&lW\r\t\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0003ger!\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001(\u000e\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}\u0002\u0015IQ\"\u0011\u0005%\u0001\u0001\"B\u0007=\u0001\u0004y\u0001\"B\u000b=\u0001\u00049\u0002\"\u0002\u0014=\u0001\u0004A\u0003\"B\u0019=\u0001\u0004\u0011\u0004bB#\u0001\u0005\u0004%\tAR\u0001\u0012[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001bX#A$\u0011\u0005QB\u0015BA%6\u0005\u0011auN\\4\t\r-\u0003\u0001\u0015!\u0003H\u0003Ii\u0017\r\u001f+ie>$H\u000f\\3US6,Wj\u001d\u0011\t\u000f5\u0003!\u0019!C\u0001\u001d\u0006aQ\r_3naR\u001cVM\\:peV\tq\n\u0005\u0002\u0019!&\u0011\u0011+\u0007\u0002\u0007'\u0016t7o\u001c:\t\rM\u0003\u0001\u0015!\u0003P\u00035)\u00070Z7qiN+gn]8sA!)Q\u000b\u0001C\u0001-\u0006a!/Z2pe\u0012,\u00050Z7qiR\u0011qK\u0017\t\u0003iaK!!W\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u00067R\u0003\r\u0001X\u0001\u0006m\u0006dW/\u001a\t\u0003iuK!AX\u001b\u0003\r\u0011{WO\u00197f\u0011\u0015\u0001\u0007\u0001\"\u0015b\u00031!\bN]8ui2,G+[7f)\r9%m\u001a\u0005\u0006G~\u0003\r\u0001Z\u0001\rG2LWM\u001c;NKR\u0014\u0018n\u0019\t\u00031\u0015L!AZ\r\u0003\u0017-\u000bgm[1NKR\u0014\u0018n\u0019\u0005\u0006\u001b}\u0003\r\u0001\u001b\t\u00031%L!A[\r\u0003\u00195+GO]5d\u0007>tg-[4\t\u000b1\u0004A\u0011K7\u0002)\rd\u0017.\u001a8u%\u0006$X-T3ue&\u001cg*Y7f)\rq'\u000f\u001e\t\u0003_Bl\u0011AG\u0005\u0003cj\u0011!\"T3ue&\u001cg*Y7f\u0011\u0015\u00198\u000e1\u00013\u00035\u0019\u0018M\\5uSj,G-V:fe\")Qo\u001ba\u0001e\u0005A1\r\\5f]RLE\rC\u0003x\u0001\u0011%\u00010\u0001\tfq\u0016l\u0007\u000f^'fiJL7MT1nKV\ta\u000eC\u0003{\u0001\u0011%10\u0001\tfq\u0016l\u0007\u000f^*f]N|'OT1nKV\t!\u0007")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;
    private final Sensor exemptSensor;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public void recordExempt(double value2) {
        this.exemptSensor().record(value2);
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        return package$.MODULE$.min(super.throttleTime(clientMetric, config), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking request-time per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder().append((Object)"exempt-").append((Object)QuotaType$Request$.MODULE$).toString();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptSensor = this.createSensor(this.exemptSensorName(), this.exemptMetricName());
    }
}

