/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaEntity;
import kafka.server.QuotaId;
import kafka.server.QuotaId$;
import kafka.server.QuotaType;
import kafka.server.QuotaTypes$;
import kafka.server.SensorAccess;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-e\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\u0013E,x\u000e^1UsB,W#A\u0019\u0011\u0005a\u0011\u0014BA\u001a\u0003\u0005%\tVo\u001c;b)f\u0004X\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0003)\tXo\u001c;b)f\u0004X\r\t\u0005\to\u0001\u0011)\u0019!C\u0005q\u0005!A/[7f+\u0005I\u0004C\u0001\u001e=\u001b\u0005Y$BA\t$\u0013\ti4H\u0001\u0003US6,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u000bQLW.\u001a\u0011\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000b\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005\r3eBA\u0005E\u0013\t)%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#\u000b\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u0019a\u0014N\\5u}Q1A*\u0014(P!F\u0003\"\u0001\u0007\u0001\t\u000bUI\u0005\u0019A\f\t\u000byI\u0005\u0019\u0001\u0011\t\u000b=J\u0005\u0019A\u0019\t\u000b]J\u0005\u0019A\u001d\t\u000b\u0005K\u0005\u0019\u0001\"\t\u000fM\u0003!\u0019!C\u0005)\u0006yqN^3se&$G-\u001a8Rk>$\u0018-F\u0001V!\u00111Vl\u00182\u000e\u0003]S!\u0001W-\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002[7\u0006!Q\u000f^5m\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX,\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002\u0019A&\u0011\u0011M\u0001\u0002\b#V|G/Y%e!\t\t3-\u0003\u0002eE\t)\u0011+^8uC\"1a\r\u0001Q\u0001\nU\u000b\u0001c\u001c<feJLG\rZ3o#V|G/\u0019\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006I2\u000f^1uS\u000e\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b+\u0005\u0011\u0007BB6\u0001A\u0003%!-\u0001\u000eti\u0006$\u0018nY\"p]\u001aLwm\u00117jK:$\u0018\nZ)v_R\f\u0007\u0005C\u0004n\u0001\u0001\u0007I\u0011\u00028\u0002#E,x\u000e^1UsB,7/\u00128bE2,G-F\u0001p!\tI\u0001/\u0003\u0002r\u0015\t\u0019\u0011J\u001c;\t\u000fM\u0004\u0001\u0019!C\u0005i\u0006)\u0012/^8uCRK\b/Z:F]\u0006\u0014G.\u001a3`I\u0015\fHCA;y!\tIa/\u0003\u0002x\u0015\t!QK\\5u\u0011\u001dI(/!AA\u0002=\f1\u0001\u001f\u00132\u0011\u0019Y\b\u0001)Q\u0005_\u0006\u0011\u0012/^8uCRK\b/Z:F]\u0006\u0014G.\u001a3!\u0011\u001di\bA1A\u0005\ny\fA\u0001\\8dWV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aV\u0001\u0006Y>\u001c7n]\u0005\u0005\u0003\u0013\t\u0019A\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0011\u001d\ti\u0001\u0001Q\u0001\n}\fQ\u0001\\8dW\u0002B\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\u0002\u0015\u0011,G.Y=Rk\u0016,X-\u0006\u0002\u0002\u0016A)a+a\u0006\u0002\u001c%\u0019\u0011\u0011D,\u0003\u0015\u0011+G.Y=Rk\u0016,X\rE\u0002\u0019\u0003;I1!a\b\u0003\u0005E!\u0006N]8ui2,GMU3ta>t7/\u001a\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0016\u0005YA-\u001a7bsF+X-^3!\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI#\u0001\btK:\u001cxN]!dG\u0016\u001c8o\u001c:\u0016\u0005\u0005-\u0002c\u0001\r\u0002.%\u0019\u0011q\u0006\u0002\u0003\u0019M+gn]8s\u0003\u000e\u001cWm]:\t\u0011\u0005M\u0002\u0001)A\u0005\u0003W\tqb]3og>\u0014\u0018iY2fgN|'\u000f\t\u0005\u000b\u0003o\u0001!\u0019!C\u0001\u0005\u0005e\u0012A\u0006;ie>$H\u000f\\3e%\u0016\fX/Z:u%\u0016\f\u0007/\u001a:\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u007fi\u0011\u0001\u0001\u0004\u0007\u0003\u0003\u0002\u0001!a\u0011\u0003-QC'o\u001c;uY\u0016$'+Z9vKN$(+Z1qKJ\u001cB!a\u0010\u0002FA\u0019q\"a\u0012\n\u0007\u0005%\u0003C\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007bCA\t\u0003\u007f\u0011\t\u0011)A\u0005\u0003+A!\"a\u0014\u0002@\t\u0005\t\u0015!\u0003C\u0003\u0019\u0001(/\u001a4jq\"9!*a\u0010\u0005\u0002\u0005MCCBA\u001e\u0003+\n9\u0006\u0003\u0005\u0002\u0012\u0005E\u0003\u0019AA\u000b\u0011\u001d\ty%!\u0015A\u0002\tC\u0001\"a\u0017\u0002@\u0011\u0005\u0013QL\u0001\u0007I><vN]6\u0015\u0003UD\u0001\"!\u0019\u0001A\u0003%\u00111H\u0001\u0018i\"\u0014x\u000e\u001e;mK\u0012\u0014V-];fgR\u0014V-\u00199fe\u0002B\u0011\"!\u001a\u0001\u0005\u0004%I!a\u001a\u0002!\u0011,G.Y=Rk\u0016,XmU3og>\u0014XCAA5!\r\t\u00131N\u0005\u0004\u0003[\u0012#AB*f]N|'\u000f\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA5\u0003E!W\r\\1z#V,W/Z*f]N|'\u000f\t\u0005\b\u0003k\u0002A\u0011BA/\u0003\u0015\u0019H/\u0019:u\u0011\u001d\tI\b\u0001C\u0001\u0003w\naC]3d_J$\u0017I\u001c3NCf\u0014W\r\u00165s_R$H.\u001a\u000b\n_\u0006u\u0014\u0011QAC\u0003\u001fCq!a \u0002x\u0001\u0007!)A\u0007tC:LG/\u001b>fIV\u001bXM\u001d\u0005\b\u0003\u0007\u000b9\b1\u0001C\u0003!\u0019G.[3oi&#\u0007\u0002CAD\u0003o\u0002\r!!#\u0002\u000bY\fG.^3\u0011\u0007%\tY)C\u0002\u0002\u000e*\u0011a\u0001R8vE2,\u0007\u0002CAI\u0003o\u0002\r!a%\u0002\u0011\r\fG\u000e\u001c2bG.\u0004R!CAK_VL1!a&\u000b\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002\u001c\u0002!\t!!(\u0002CI,7m\u001c:e\u0003:$G\u000b\u001b:piRdWm\u00148Rk>$\u0018MV5pY\u0006$\u0018n\u001c8\u0015\u000f=\fy*!+\u0002,\"A\u0011\u0011UAM\u0001\u0004\t\u0019+A\u0007dY&,g\u000e^*f]N|'o\u001d\t\u00041\u0005\u0015\u0016bAAT\u0005\ti1\t\\5f]R\u001cVM\\:peND\u0001\"a\"\u0002\u001a\u0002\u0007\u0011\u0011\u0012\u0005\t\u0003#\u000bI\n1\u0001\u0002\u0014\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0016\u0001\u0005:fG>\u0014HMT8UQJ|G\u000f\u001e7f)\u0015)\u00181WA[\u0011!\t\t+!,A\u0002\u0005\r\u0006\u0002CAD\u0003[\u0003\r!!#\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\u0006Y\u0011/^8uC\u0016sG/\u001b;z)\u0019\ti,a1\u0002FB\u0019\u0001$a0\n\u0007\u0005\u0005'AA\u0006Rk>$\u0018-\u00128uSRL\bbBA@\u0003o\u0003\rA\u0011\u0005\b\u0003\u0007\u000b9\f1\u0001C\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017\f!%];pi\u0006,e\u000e^5us^KG\u000f['vYRL\u0007\u000f\\3Rk>$\u0018\rT3wK2\u001cHCBA_\u0003\u001b\fy\rC\u0004\u0002\u0000\u0005\u001d\u0007\u0019\u0001\"\t\u000f\u0005\r\u0015q\u0019a\u0001\u0005\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0017!B9v_R\fG#\u00022\u0002X\u0006m\u0007bBAm\u0003#\u0004\rAQ\u0001\u0005kN,'\u000fC\u0004\u0002\u0004\u0006E\u0007\u0019\u0001\"\t\u000f\u0005}\u0007\u0001\"\u0005\u0002b\u0006aA\u000f\u001b:piRdW\rV5nKR1\u00111]Au\u0003g\u00042!CAs\u0013\r\t9O\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0002l\u0006u\u0007\u0019AAw\u00031\u0019G.[3oi6+GO]5d!\r\t\u0013q^\u0005\u0004\u0003c\u0014#aC&bM.\fW*\u001a;sS\u000eDq!FAo\u0001\u0004\t)\u0010E\u0002\"\u0003oL1!!?#\u00051iU\r\u001e:jG\u000e{gNZ5h\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007f\f\u0001#\\3bgV\u0014\u0018M\u00197f\u0003N\u0014\u0016\r^3\u0015\r\t\u0005!Q\u0002B\r!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!b\u0001B\u0004E\u0005)1\u000f^1ug&!!1\u0002B\u0003\u0005\u0011\u0011\u0016\r^3\t\u0011\t=\u00111 a\u0001\u0005#\tAA\\1nKB!!1\u0003B\u000b\u001b\u0005\u0019\u0013b\u0001B\fG\tQQ*\u001a;sS\u000et\u0015-\\3\t\u0011\tm\u00111 a\u0001\u0005;\t!\"\\3bgV\u0014\u0018M\u00197f!\r\t#qD\u0005\u0004\u0005C\u0011#AC'fCN,(/\u00192mK\"9!Q\u0005\u0001\u0005\u0002\t\u001d\u0012aF4fi>\u00138I]3bi\u0016\fVo\u001c;b'\u0016t7o\u001c:t)\u0019\t\u0019K!\u000b\u0003,!9\u0011q\u0010B\u0012\u0001\u0004\u0011\u0005bBAB\u0005G\u0001\rA\u0011\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u00039iW-Y:ve\u0006\u0014G.Z*uCR,\"Aa\r\u0011\u0007\u0005\u0012)$C\u0002\u00038\t\u0012a\"T3bgV\u0014\u0018M\u00197f'R\fG\u000fC\u0004\u0003<\u0001!IA!\u0010\u00023\u001d,G\u000f\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe:\u000bW.\u001a\u000b\u0004\u0005\n}\u0002b\u0002B!\u0005s\u0001\raX\u0001\bcV|G/Y%e\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000f\n!cZ3u#V|G/Y*f]N|'OT1nKR\u0019!I!\u0013\t\u000f\t\u0005#1\ta\u0001?\"9!Q\n\u0001\u0005\u0012\t=\u0013\u0001F4fiF+x\u000e^1NKR\u0014\u0018nY\"p]\u001aLw\r\u0006\u0003\u0002v\nE\u0003bBAj\u0005\u0017\u0002\rA\u0019\u0005\b\u0005+\u0002A\u0011\u0003B,\u00031\u0019'/Z1uKN+gn]8s)\u0019\tIG!\u0017\u0003^!9!1\fB*\u0001\u0004\u0011\u0015AC:f]N|'OT1nK\"A!q\fB*\u0001\u0004\u0011\t\"\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016DqAa\u0019\u0001\t\u0003\u0011)'A\u0006va\u0012\fG/Z)v_R\fGcB;\u0003h\t=$\u0011\u000f\u0005\t\u0003\u007f\u0012\t\u00071\u0001\u0003jA!\u0011Ba\u001bC\u0013\r\u0011iG\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\r%\u0011\ra\u0001\u0005SB\u0001\"a5\u0003b\u0001\u0007!1\u000f\t\u0005\u0013\t-$\rC\u0004\u0003x\u0001!\tB!\u001f\u0002)\rd\u0017.\u001a8u%\u0006$X-T3ue&\u001cg*Y7f)\u0019\u0011\tBa\u001f\u0003~!9\u0011q\u0010B;\u0001\u0004\u0011\u0005bBAB\u0005k\u0002\rA\u0011\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0003I!\bN]8ui2,W*\u001a;sS\u000et\u0015-\\3\u0015\t\tE!Q\u0011\u0005\t\u0003s\u0013y\b1\u0001\u0002>\"9!\u0011\u0012\u0001\u0005\u0002\u0005u\u0013\u0001C:ikR$wn\u001e8")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType kafka$server$ClientQuotaManager$$quotaType;
    private final Time time;
    private final ConcurrentHashMap<QuotaId, Quota> overriddenQuota;
    private final Quota staticConfigClientIdQuota;
    private int quotaTypesEnabled;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final SensorAccess sensorAccessor;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public QuotaType kafka$server$ClientQuotaManager$$quotaType() {
        return this.kafka$server$ClientQuotaManager$$quotaType;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<QuotaId, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota staticConfigClientIdQuota() {
        return this.staticConfigClientIdQuota;
    }

    private int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    private void quotaTypesEnabled_$eq(int x$1) {
        this.quotaTypesEnabled = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    private void start() {
        this.throttledRequestReaper().start();
    }

    public int recordAndMaybeThrottle(String sanitizedUser, String clientId, double value2, Function1<Object, BoxedUnit> callback) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(sanitizedUser, clientId);
        return this.recordAndThrottleOnQuotaViolation(clientSensors, value2, callback);
    }

    public int recordAndThrottleOnQuotaViolation(ClientSensors clientSensors, double value2, Function1<Object, BoxedUnit> callback) {
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record(value2);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException quotaViolationException) {
            QuotaEntity clientQuotaEntity = clientSensors.quotaEntity();
            KafkaMetric clientMetric = (KafkaMetric)this.metrics().metrics().get(this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()));
            throttleTimeMs = (int)RichLong$.MODULE$.round$extension(Predef$.MODULE$.longWrapper(this.throttleTime(clientMetric, this.getQuotaMetricConfig(clientQuotaEntity.quota()))));
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    public void recordNoThrottle(ClientSensors clientSensors, double value2) {
        clientSensors.quotaSensor().record(value2, this.time().milliseconds(), false);
    }

    public QuotaEntity kafka$server$ClientQuotaManager$$quotaEntity(String sanitizedUser, String clientId) {
        QuotaEntity quotaEntity;
        int n = this.quotaTypesEnabled();
        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n;
        if (bl) {
            QuotaId quotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultClientIdQuotaId())) == null) {
                quota = this.staticConfigClientIdQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, "", clientId, quota);
        } else if (QuotaTypes$.MODULE$.UserQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, "", quota);
        } else if (QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default())))) == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId)))) == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserClientIdQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, clientId, quota);
        } else {
            quotaEntity = this.quotaEntityWithMultipleQuotaLevels(sanitizedUser, clientId);
        }
        return quotaEntity;
    }

    private QuotaEntity quotaEntityWithMultipleQuotaLevels(String sanitizedUser, String clientId) {
        QuotaId userClientQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
        QuotaId userQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
        QuotaId clientQuotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
        QuotaId quotaId = userClientQuotaId;
        QuotaId quotaConfigId = userClientQuotaId;
        Quota quota = this.overriddenQuota().get(quotaConfigId);
        if (quota == null) {
            quotaId = userClientQuotaId;
            quotaConfigId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
            quota = this.overriddenQuota().get(quotaConfigId);
            if (quota == null) {
                quotaConfigId = quotaId = userQuotaId;
                quota = this.overriddenQuota().get(quotaConfigId);
                if (quota == null) {
                    quotaId = userClientQuotaId;
                    quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId));
                    quota = this.overriddenQuota().get(quotaConfigId);
                    if (quota == null) {
                        quotaId = userClientQuotaId;
                        quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                        quota = this.overriddenQuota().get(quotaConfigId);
                        if (quota == null) {
                            quotaId = userQuotaId;
                            quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
                            quota = this.overriddenQuota().get(quotaConfigId);
                            if (quota == null) {
                                quotaId = clientQuotaId;
                                quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
                                quota = this.overriddenQuota().get(quotaConfigId);
                                if (quota == null) {
                                    quotaId = clientQuotaId;
                                    quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                                    quota = this.overriddenQuota().get(quotaConfigId);
                                    if (quota == null) {
                                        quotaId = clientQuotaId;
                                        quotaConfigId = null;
                                        quota = this.staticConfigClientIdQuota();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        QuotaId quotaId2 = quotaId;
        QuotaId quotaId3 = clientQuotaId;
        String quotaUser = !(quotaId2 != null ? !((Object)quotaId2).equals(quotaId3) : quotaId3 != null) ? "" : sanitizedUser;
        QuotaId quotaId4 = quotaId;
        QuotaId quotaId5 = userQuotaId;
        String quotaClientId = !(quotaId4 != null ? !((Object)quotaId4).equals(quotaId5) : quotaId5 != null) ? "" : clientId;
        return new QuotaEntity(quotaId, quotaUser, quotaClientId, quota);
    }

    public Quota quota(String user, String clientId) {
        return this.kafka$server$ClientQuotaManager$$quotaEntity(QuotaId$.MODULE$.sanitize(user), clientId).quota();
    }

    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Measurable measurable2 = measurable;
        if (measurable2 instanceof Rate) {
            Rate rate;
            Rate rate2 = rate = (Rate)measurable2;
            return rate2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
    }

    public ClientSensors getOrCreateQuotaSensors(String sanitizedUser, String clientId) {
        QuotaEntity clientQuotaEntity = this.kafka$server$ClientQuotaManager$$quotaEntity(sanitizedUser, clientId);
        return new ClientSensors(clientQuotaEntity, this.sensorAccessor().getOrCreate(this.getQuotaSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricName apply() {
                return this.$outer.clientRateMetricName(this.clientQuotaEntity$1.sanitizedUser(), this.clientQuotaEntity$1.clientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricConfig apply() {
                return this.$outer.getQuotaMetricConfig(this.clientQuotaEntity$1.quota());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;

            public final MeasurableStat apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$measurableStat();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), this.sensorAccessor().getOrCreate(this.getThrottleTimeSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricName apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$throttleMetricName(this.clientQuotaEntity$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Avg apply() {
                return new Avg();
            }
        }));
    }

    public MeasurableStat kafka$server$ClientQuotaManager$$measurableStat() {
        return new Rate();
    }

    private String getThrottleTimeSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "ThrottleTime-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    private String getQuotaSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    public MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor createSensor(String sensorName, MetricName metricName) {
        return this.sensorAccessor().getOrCreate(sensorName, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final MetricName metricName$1;

            public final MetricName apply() {
                return this.metricName$1;
            }
            {
                this.metricName$1 = metricName$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;

            public final MeasurableStat apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$measurableStat();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateQuota(Option<String> sanitizedUser, Option<String> clientId, Option<Quota> quota) {
        this.lock().writeLock().lock();
        try {
            Option<String> option;
            block13: {
                Option<String> option2;
                block17: {
                    Option<Quota> option3;
                    block25: {
                        String clientIdInfo;
                        String userInfo;
                        block24: {
                            Quota quota2;
                            QuotaId quotaId;
                            block18: {
                                Tuple2 tuple2;
                                block23: {
                                    block20: {
                                        block22: {
                                            block21: {
                                                block19: {
                                                    String string;
                                                    block15: {
                                                        block16: {
                                                            Some some;
                                                            boolean bl;
                                                            block14: {
                                                                String string2;
                                                                block11: {
                                                                    block12: {
                                                                        Some some2;
                                                                        boolean bl2;
                                                                        block10: {
                                                                            quotaId = new QuotaId(sanitizedUser, clientId);
                                                                            bl2 = false;
                                                                            some2 = null;
                                                                            option = sanitizedUser;
                                                                            if (!(option instanceof Some)) break block10;
                                                                            bl2 = true;
                                                                            some2 = (Some)option;
                                                                            String string3 = (String)some2.x();
                                                                            String string4 = ConfigEntityName$.MODULE$.Default();
                                                                            String string5 = string3;
                                                                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block10;
                                                                            string2 = "default user ";
                                                                            break block11;
                                                                        }
                                                                        if (!bl2) break block12;
                                                                        String user = (String)some2.x();
                                                                        string2 = new StringBuilder().append((Object)"user ").append((Object)user).append((Object)" ").toString();
                                                                        break block11;
                                                                    }
                                                                    if (!None$.MODULE$.equals(option)) break block13;
                                                                    string2 = "";
                                                                }
                                                                userInfo = string2;
                                                                bl = false;
                                                                some = null;
                                                                option2 = clientId;
                                                                if (!(option2 instanceof Some)) break block14;
                                                                bl = true;
                                                                some = (Some)option2;
                                                                String string6 = (String)some.x();
                                                                String string7 = ConfigEntityName$.MODULE$.Default();
                                                                String string8 = string6;
                                                                if (string7 != null ? !string7.equals(string8) : string8 != null) break block14;
                                                                string = "default client-id";
                                                                break block15;
                                                            }
                                                            if (!bl) break block16;
                                                            String id = (String)some.x();
                                                            string = new StringBuilder().append((Object)"client-id ").append((Object)id).toString();
                                                            break block15;
                                                        }
                                                        if (!None$.MODULE$.equals(option2)) break block17;
                                                        string = "";
                                                    }
                                                    clientIdInfo = string;
                                                    option3 = quota;
                                                    if (!(option3 instanceof Some)) break block18;
                                                    Some some = (Some)option3;
                                                    Quota newQuota = (Quota)some.x();
                                                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing ", " quota for ", "", " to ", ".bound}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo, newQuota})));
                                                    this.overriddenQuota().put(quotaId, newQuota);
                                                    tuple2 = new Tuple2(sanitizedUser, clientId);
                                                    if (tuple2 == null) break block19;
                                                    Option option4 = (Option)tuple2._1();
                                                    Option option5 = (Option)tuple2._2();
                                                    if (!(option4 instanceof Some) || !(option5 instanceof Some)) break block19;
                                                    this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserClientIdQuotaEnabled());
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block20;
                                                }
                                                if (tuple2 == null) break block21;
                                                Option option6 = (Option)tuple2._1();
                                                Option option7 = (Option)tuple2._2();
                                                if (!(option6 instanceof Some) || !None$.MODULE$.equals(option7)) break block21;
                                                this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserQuotaEnabled());
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block20;
                                            }
                                            if (tuple2 == null) break block22;
                                            Option option8 = (Option)tuple2._1();
                                            Option option9 = (Option)tuple2._2();
                                            if (!None$.MODULE$.equals(option8) || !(option9 instanceof Some)) break block22;
                                            this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.ClientIdQuotaEnabled());
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block20;
                                        }
                                        if (tuple2 == null) break block23;
                                        Option option10 = (Option)tuple2._1();
                                        Option option11 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option10) || !None$.MODULE$.equals(option11)) break block23;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    quota2 = BoxedUnit.UNIT;
                                    break block24;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            if (!None$.MODULE$.equals(option3)) break block25;
                            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " quota for ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo})));
                            quota2 = this.overriddenQuota().remove(quotaId);
                        }
                        MetricName quotaMetricName = this.clientRateMetricName((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }), (String)clientId.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }));
                        Map allMetrics = this.metrics().metrics();
                        int n = this.quotaTypesEnabled();
                        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : (QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n ? true : (QuotaTypes$.MODULE$.UserQuotaEnabled() == n ? true : QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n));
                        boolean bl3 = bl ? !sanitizedUser.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$1) {
                                String string = x$1;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() && !clientId.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$2) {
                                String string = x$2;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() : false;
                        boolean singleUpdate = bl3;
                        if (singleUpdate) {
                            KafkaMetric metric = (KafkaMetric)allMetrics.get(quotaMetricName);
                            if (metric != null) {
                                QuotaEntity metricConfigEntity = this.kafka$server$ClientQuotaManager$$quotaEntity((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (String)clientId.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }));
                                Quota newQuota = metricConfigEntity.quota();
                                this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for ", "", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                metric.config(this.getQuotaMetricConfig(newQuota));
                            }
                        } else {
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allMetrics).asScala()).filterKeys((Function1)new Serializable(this, quotaMetricName){
                                public static final long serialVersionUID = 0L;
                                private final MetricName quotaMetricName$1;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean apply(MetricName n) {
                                    String string = n.name();
                                    String string2 = this.quotaMetricName$1.name();
                                    if (string == null) {
                                        if (string2 != null) {
                                            return false;
                                        }
                                    } else if (!string.equals(string2)) return false;
                                    String string3 = n.group();
                                    String string4 = this.quotaMetricName$1.group();
                                    if (string3 == null) {
                                        if (string4 == null) return true;
                                        return false;
                                    } else {
                                        if (!string3.equals(string4)) return false;
                                        return true;
                                    }
                                }
                                {
                                    this.quotaMetricName$1 = quotaMetricName$1;
                                }
                            }).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ClientQuotaManager $outer;

                                public final void apply(Tuple2<MetricName, KafkaMetric> x0$1) {
                                    Tuple2<MetricName, KafkaMetric> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        BoxedUnit boxedUnit;
                                        MetricName metricName = (MetricName)tuple2._1();
                                        KafkaMetric metric = (KafkaMetric)tuple2._2();
                                        String userTag = metricName.tags().containsKey("user") ? (String)metricName.tags().get("user") : "";
                                        String clientIdTag = metricName.tags().containsKey("client-id") ? (String)metricName.tags().get("client-id") : "";
                                        QuotaEntity metricConfigEntity = this.$outer.kafka$server$ClientQuotaManager$$quotaEntity(userTag, clientIdTag);
                                        Quota quota = metricConfigEntity.quota();
                                        Quota quota2 = metric.config().quota();
                                        if (!(quota != null ? !quota.equals(quota2) : quota2 != null)) {
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            Quota newQuota = metricConfigEntity.quota();
                                            this.$outer.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for quota-id ", " already exists. Setting quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricConfigEntity.quotaId(), BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                            metric.config(this.$outer.getQuotaMetricConfig(newQuota));
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        return;
                    }
                    throw new MatchError(option3);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking byte-rate per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    public MetricName kafka$server$ClientQuotaManager$$throttleMetricName(QuotaEntity quotaEntity) {
        return this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking average throttle-time per user/client-id", new String[]{"user", quotaEntity.sanitizedUser(), "client-id", quotaEntity.clientId()});
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time, String threadNamePrefix) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$quotaType = quotaType;
        this.time = time;
        Logging$class.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.staticConfigClientIdQuota = Quota.upperBound((double)config.quotaBytesPerSecondDefault());
        this.quotaTypesEnabled = config.quotaBytesPerSecondDefault() == Long.MAX_VALUE ? QuotaTypes$.MODULE$.NoQuotas() : QuotaTypes$.MODULE$.ClientIdQuotaEnabled();
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.sensorAccessor = new SensorAccess();
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue(), threadNamePrefix);
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)quotaType), "-delayQueue"));
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", quotaType.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new Total());
        this.start();
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
            if (response != null) {
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)new Serializable(this, response){
                    public static final long serialVersionUID = 0L;
                    private final ThrottledResponse response$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Response throttled for: ").append((Object)BoxesRunTime.boxToInteger((int)this.response$1.throttleTimeMs())).append((Object)" ms").toString();
                    }
                    {
                        this.response$1 = response$1;
                    }
                });
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue, String prefix) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "ThrottledRequestReaper-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, $outer.kafka$server$ClientQuotaManager$$quotaType()})), false);
        }
    }
}

