/*
 * Decompiled with CFR 0.152.
 */
package kafka.om;

import kafka.common.KafkaException;
import kafka.om.checkBrokerStartComplete$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class checkBrokerStartComplete$ {
    public static final checkBrokerStartComplete$ MODULE$;
    private String brokerIdsPath;
    private ZkUtils zkUtils;
    private String zkConnect;
    private int zkSessionTimeoutMs;
    private int zkConnectionTimeoutMs;
    private boolean zkEnableSecureAcls;
    private Seq<Object> brokerIds;
    private final int argsCount;
    private Seq<String> topicList;

    static {
        new checkBrokerStartComplete$();
    }

    public String brokerIdsPath() {
        return this.brokerIdsPath;
    }

    public void brokerIdsPath_$eq(String x$1) {
        this.brokerIdsPath = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public String zkConnect() {
        return this.zkConnect;
    }

    public void zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void zkSessionTimeoutMs_$eq(int x$1) {
        this.zkSessionTimeoutMs = x$1;
    }

    public int zkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }

    public void zkConnectionTimeoutMs_$eq(int x$1) {
        this.zkConnectionTimeoutMs = x$1;
    }

    public boolean zkEnableSecureAcls() {
        return this.zkEnableSecureAcls;
    }

    public void zkEnableSecureAcls_$eq(boolean x$1) {
        this.zkEnableSecureAcls = x$1;
    }

    public Seq<Object> brokerIds() {
        return this.brokerIds;
    }

    public void brokerIds_$eq(Seq<Object> x$1) {
        this.brokerIds = x$1;
    }

    public int argsCount() {
        return this.argsCount;
    }

    public Seq<String> topicList() {
        return this.topicList;
    }

    public void topicList_$eq(Seq<String> x$1) {
        this.topicList = x$1;
    }

    public void main(String[] args) {
        block9: {
            if (args.length != this.argsCount()) {
                Predef$.MODULE$.println((Object)"ERROR: args count is invalid.");
                System.exit(1);
            }
            int exitCode = 0;
            try {
                try {
                    this.zkConnect_$eq(args[0]);
                    this.zkSessionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt());
                    this.zkConnectionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt());
                    this.zkEnableSecureAcls_$eq(new StringOps(Predef$.MODULE$.augmentString(args[3])).toBoolean());
                    int brokerInstanceId = new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt();
                    this.zkUtils_$eq(this.initZk());
                    this.brokerIds_$eq(this.zkUtils().getSortedBrokerList());
                    String checkPath = new StringBuilder().append((Object)this.brokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerInstanceId)).toString();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Checking broker id path : ").append((Object)checkPath).toString());
                    if (this.brokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerInstanceId))) {
                        Predef$.MODULE$.println((Object)"Checked broker id path success.");
                        boolean result = this.checkPartitionsISR(this.zkUtils(), brokerInstanceId);
                        if (result) {
                            Predef$.MODULE$.println((Object)"Checked partitions ISR success.");
                            break block9;
                        }
                        throw new KafkaException("The current broker is not all replicas in the partition's ISR.");
                    }
                    throw new KafkaException("The broker id path is not Exists.");
                }
                catch (Throwable throwable) {
                    Predef$.MODULE$.println((Object)throwable);
                    exitCode = 1;
                }
            }
            finally {
                if (this.zkUtils() != null) {
                    this.zkUtils().close();
                }
                System.exit(exitCode);
            }
        }
    }

    private boolean checkPartitionsISR(ZkUtils zkUtils, int id) {
        Object object = new Object();
        try {
            Predef$.MODULE$.println((Object)"To check partitions isr list.");
            this.topicList_$eq(zkUtils.getAllTopics());
            this.topicList().foreach((Function1)new Serializable(zkUtils, id, object){
                public static final long serialVersionUID = 0L;
                public final ZkUtils zkUtils$1;
                public final int id$1;
                public final Object nonLocalReturnKey1$1;

                public final void apply(String topic) {
                    Option option;
                    block4: {
                        block3: {
                            block2: {
                                option = this.zkUtils$1.getPartitionAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Map topicPartitionAssignment = (Map)some.x();
                                topicPartitionAssignment.withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<Object, Seq<Object>> check$ifrefutable$1) {
                                        Tuple2<Object, Seq<Object>> tuple2 = check$ifrefutable$1;
                                        boolean bl = tuple2 != null;
                                        return bl;
                                    }
                                }).foreach((Function1)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.checkPartitionsISR.1 $outer;
                                    private final String topic$1;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final void apply(Tuple2<Object, Seq<Object>> x$1) {
                                        BoxedUnit boxedUnit;
                                        Tuple2<Object, Seq<Object>> tuple2 = x$1;
                                        if (tuple2 == null) throw new MatchError(tuple2);
                                        int partitionId = tuple2._1$mcI$sp();
                                        Seq assignedReplicas = (Seq)tuple2._2();
                                        if (assignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.id$1))) {
                                            Seq<Object> inSyncReplicas = this.$outer.zkUtils$1.getInSyncReplicasForPartition(this.topic$1, partitionId);
                                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Topic:").append((Object)this.topic$1).append((Object)" Partition:").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).append((Object)" Replicas:").append((Object)assignedReplicas).append((Object)" ISR:").append(inSyncReplicas).toString());
                                            if (!inSyncReplicas.contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.id$1))) throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, false);
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.topic$1 = topic$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Topic ").append((Object)topic).append((Object)" doesn't exist!").toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError((Object)option);
                }
                {
                    this.zkUtils$1 = zkUtils$1;
                    this.id$1 = id$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    private ZkUtils initZk() {
        boolean secureAclsEnabled;
        String chroot = "";
        chroot = this.zkConnect().indexOf("/") > 0 ? this.zkConnect().substring(this.zkConnect().indexOf("/")) : "";
        this.brokerIdsPath_$eq(new StringBuilder().append((Object)chroot).append((Object)this.brokerIdsPath()).toString());
        boolean bl = secureAclsEnabled = JaasUtils.isZkSecurityEnabled() && this.zkEnableSecureAcls();
        if (this.zkEnableSecureAcls() && !secureAclsEnabled) {
            throw new SecurityException("zkEnableSecureAcls is true, but the verification of the JAAS login file failed.");
        }
        if (chroot.length() > 1) {
            String zkConnForChrootCreation = this.zkConnect().substring(0, this.zkConnect().indexOf("/"));
            ZkUtils zkClientForChrootCreation = ZkUtils$.MODULE$.apply(zkConnForChrootCreation, this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
            zkClientForChrootCreation.zkClient().close();
        }
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
        return zkUtils;
    }

    private checkBrokerStartComplete$() {
        MODULE$ = this;
        this.brokerIdsPath = "/brokers/ids";
        this.zkUtils = null;
        this.zkConnect = "";
        this.zkSessionTimeoutMs = 6000;
        this.zkConnectionTimeoutMs = 6000;
        this.zkEnableSecureAcls = false;
        this.brokerIds = null;
        this.argsCount = 5;
        this.topicList = null;
    }
}

