/*
 * Decompiled with CFR 0.152.
 */
package kafka.om;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import kafka.common.KafkaException;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class checkBrokerInstanceHealth$ {
    public static final checkBrokerInstanceHealth$ MODULE$;
    private String BrokerIdsPath;
    private ZkUtils zkUtils;
    private JMXConnector connector;
    private MBeanServerConnection mbeanConn;
    private String chroot;
    private String zkConnect;
    private int zkSessionTimeoutMs;
    private int zkConnectionTimeoutMs;
    private boolean zkEnableSecureAcls;
    private Seq<Object> brokerIds;
    private int controllerId;
    private final int argsCount;

    static {
        new checkBrokerInstanceHealth$();
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public void BrokerIdsPath_$eq(String x$1) {
        this.BrokerIdsPath = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public JMXConnector connector() {
        return this.connector;
    }

    public void connector_$eq(JMXConnector x$1) {
        this.connector = x$1;
    }

    public MBeanServerConnection mbeanConn() {
        return this.mbeanConn;
    }

    public void mbeanConn_$eq(MBeanServerConnection x$1) {
        this.mbeanConn = x$1;
    }

    public String chroot() {
        return this.chroot;
    }

    public void chroot_$eq(String x$1) {
        this.chroot = x$1;
    }

    public String zkConnect() {
        return this.zkConnect;
    }

    public void zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void zkSessionTimeoutMs_$eq(int x$1) {
        this.zkSessionTimeoutMs = x$1;
    }

    public int zkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }

    public void zkConnectionTimeoutMs_$eq(int x$1) {
        this.zkConnectionTimeoutMs = x$1;
    }

    public boolean zkEnableSecureAcls() {
        return this.zkEnableSecureAcls;
    }

    public void zkEnableSecureAcls_$eq(boolean x$1) {
        this.zkEnableSecureAcls = x$1;
    }

    public Seq<Object> brokerIds() {
        return this.brokerIds;
    }

    public void brokerIds_$eq(Seq<Object> x$1) {
        this.brokerIds = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public void controllerId_$eq(int x$1) {
        this.controllerId = x$1;
    }

    public int argsCount() {
        return this.argsCount;
    }

    public void main(String[] args) {
        block9: {
            if (args.length != this.argsCount()) {
                Predef$.MODULE$.println((Object)"ERROR: args count is invalid.");
                System.exit(1);
            }
            int exitCode = 0;
            try {
                try {
                    this.zkConnect_$eq(args[0]);
                    this.zkSessionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt());
                    this.zkConnectionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt());
                    this.zkEnableSecureAcls_$eq(new StringOps(Predef$.MODULE$.augmentString(args[3])).toBoolean());
                    int brokerInstanceId = new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt();
                    String connectJMXURL = args[5];
                    JMXServiceURL serviceUrl = new JMXServiceURL(connectJMXURL);
                    this.connector_$eq(JMXConnectorFactory.connect(serviceUrl, null));
                    this.mbeanConn_$eq(this.connector().getMBeanServerConnection());
                    this.zkUtils_$eq(this.initZk());
                    this.brokerIds_$eq(this.zkUtils().getSortedBrokerList());
                    String checkPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerInstanceId)).toString();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Checking broker id path : ").append((Object)checkPath).toString());
                    if (this.brokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerInstanceId))) {
                        Predef$.MODULE$.println((Object)"Checked broker id path success.");
                        break block9;
                    }
                    throw new KafkaException("The broker id path is not Exists.");
                }
                catch (Throwable throwable) {
                    Predef$.MODULE$.println((Object)throwable);
                    exitCode = 1;
                }
            }
            finally {
                if (this.zkUtils() != null) {
                    this.zkUtils().close();
                }
                if (this.connector() != null) {
                    this.connector().close();
                }
                System.exit(exitCode);
            }
        }
    }

    private ZkUtils initZk() {
        boolean secureAclsEnabled;
        this.chroot_$eq(this.zkConnect().indexOf("/") > 0 ? this.zkConnect().substring(this.zkConnect().indexOf("/")) : "");
        this.BrokerIdsPath_$eq(new StringBuilder().append((Object)this.chroot()).append((Object)this.BrokerIdsPath()).toString());
        boolean bl = secureAclsEnabled = JaasUtils.isZkSecurityEnabled() && this.zkEnableSecureAcls();
        if (this.zkEnableSecureAcls() && !secureAclsEnabled) {
            throw new SecurityException("zkEnableSecureAcls is true, but the verification of the JAAS login file failed.");
        }
        if (this.chroot().length() > 1) {
            String zkConnForChrootCreation = this.zkConnect().substring(0, this.zkConnect().indexOf("/"));
            ZkUtils zkClientForChrootCreation = ZkUtils$.MODULE$.apply(zkConnForChrootCreation, this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
            zkClientForChrootCreation.zkClient().close();
        }
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
        return zkUtils;
    }

    private checkBrokerInstanceHealth$() {
        MODULE$ = this;
        this.BrokerIdsPath = "/brokers/ids";
        this.zkUtils = null;
        this.connector = null;
        this.mbeanConn = null;
        this.chroot = "";
        this.zkConnect = "";
        this.zkSessionTimeoutMs = 6000;
        this.zkConnectionTimeoutMs = 6000;
        this.zkEnableSecureAcls = false;
        this.brokerIds = null;
        this.controllerId = -1;
        this.argsCount = 6;
    }
}

