/*
 * Decompiled with CFR 0.152.
 */
package kafka.om;

import kafka.common.KafkaException;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class checkBrokerAvailable$
implements Logging {
    public static final checkBrokerAvailable$ MODULE$;
    private ZkUtils zkUtils;
    private String chroot;
    private String zkConnect;
    private int zkSessionTimeoutMs;
    private int zkConnectionTimeoutMs;
    private boolean zkEnableSecureAcls;
    private Seq<Object> brokerIds;
    private int controllerId;
    private final int argsCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new checkBrokerAvailable$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        checkBrokerAvailable$ checkBrokerAvailable$2 = this;
        synchronized (checkBrokerAvailable$2) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public String chroot() {
        return this.chroot;
    }

    public void chroot_$eq(String x$1) {
        this.chroot = x$1;
    }

    public String zkConnect() {
        return this.zkConnect;
    }

    public void zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void zkSessionTimeoutMs_$eq(int x$1) {
        this.zkSessionTimeoutMs = x$1;
    }

    public int zkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }

    public void zkConnectionTimeoutMs_$eq(int x$1) {
        this.zkConnectionTimeoutMs = x$1;
    }

    public boolean zkEnableSecureAcls() {
        return this.zkEnableSecureAcls;
    }

    public void zkEnableSecureAcls_$eq(boolean x$1) {
        this.zkEnableSecureAcls = x$1;
    }

    public Seq<Object> brokerIds() {
        return this.brokerIds;
    }

    public void brokerIds_$eq(Seq<Object> x$1) {
        this.brokerIds = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public void controllerId_$eq(int x$1) {
        this.controllerId = x$1;
    }

    public int argsCount() {
        return this.argsCount;
    }

    public void main(String[] args) {
        if (args.length != this.argsCount()) {
            Predef$.MODULE$.println((Object)"USAGE: java [options] checkBrokerAvailable zookeeper_connect zookeeper_session_timeout zookeeper_connection_timeout");
            System.exit(1);
        }
        int exitCode = 0;
        try {
            try {
                this.zkConnect_$eq(args[0]);
                this.zkSessionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt());
                this.zkConnectionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt());
                this.zkEnableSecureAcls_$eq(new StringOps(Predef$.MODULE$.augmentString(args[3])).toBoolean());
                this.zkUtils_$eq(this.initZk());
                this.brokerIds_$eq(this.zkUtils().getSortedBrokerList());
                if (0 == this.brokerIds().size()) {
                    throw new KafkaException("No broker exists.");
                }
                this.controllerId_$eq(this.zkUtils().getController());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Checking controllerId is ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).append((Object)", brokerIds is ").append(this.brokerIds()).toString());
                if (!this.brokerIds().contains((Object)BoxesRunTime.boxToInteger((int)this.controllerId()))) {
                    this.error((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "The controller id is not in broker id list.";
                        }
                    });
                    exitCode = 1;
                }
            }
            catch (Throwable throwable) {
                this.fatal((Function0<Throwable>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                exitCode = 1;
            }
        }
        finally {
            if (this.zkUtils() != null) {
                this.zkUtils().close();
            }
            System.exit(exitCode);
        }
    }

    private ZkUtils initZk() {
        boolean secureAclsEnabled;
        this.chroot_$eq(this.zkConnect().indexOf("/") > 0 ? this.zkConnect().substring(this.zkConnect().indexOf("/")) : "");
        boolean bl = secureAclsEnabled = JaasUtils.isZkSecurityEnabled() && this.zkEnableSecureAcls();
        if (this.zkEnableSecureAcls() && !secureAclsEnabled) {
            throw new SecurityException("zkEnableSecureAcls is true, but the verification of the JAAS login file failed.");
        }
        if (this.chroot().length() > 1) {
            String zkConnForChrootCreation = this.zkConnect().substring(0, this.zkConnect().indexOf("/"));
            ZkUtils zkClientForChrootCreation = ZkUtils$.MODULE$.apply(zkConnForChrootCreation, this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
            zkClientForChrootCreation.zkClient().close();
        }
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
        return zkUtils;
    }

    private checkBrokerAvailable$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.zkUtils = null;
        this.chroot = "";
        this.zkConnect = "";
        this.zkSessionTimeoutMs = 6000;
        this.zkConnectionTimeoutMs = 6000;
        this.zkEnableSecureAcls = false;
        this.brokerIds = null;
        this.controllerId = -1;
        this.argsCount = 4;
    }
}

