/*
 * Decompiled with CFR 0.152.
 */
package kafka.om;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Json$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class MonitorBrokerInfo$ {
    public static final MonitorBrokerInfo$ MODULE$;
    private final int zkSessionTimeoutMs;
    private final int zkConnectionTimeoutMs;

    static {
        new MonitorBrokerInfo$();
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public int zkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Print the broker info.");
        }
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        ObjectRef zkUtils = ObjectRef.create(null);
        try {
            try {
                zkUtils.elem = ZkUtils$.MODULE$.apply(zkConnect, this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), false);
                List brokerIds = ((ZkUtils)zkUtils.elem).getChildren(ZkUtils$.MODULE$.BrokerIdsPath()).toList();
                Predef$.MODULE$.println((Object)"Broker_ID     IP_Address");
                Predef$.MODULE$.println((Object)"--------------------------");
                brokerIds.foreach((Function1)new Serializable(zkUtils){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef zkUtils$1;

                    public final void apply(String id) {
                        Option option = (Option)((ZkUtils)this.zkUtils$1.elem).readDataMaybeNull(new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)id).toString())._1();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String brokerInfoString = (String)some.x();
                            Option<Object> option2 = Json$.MODULE$.parseFull(brokerInfoString);
                            if (option2 instanceof Some) {
                                Some some2 = (Some)option2;
                                Object m = some2.x();
                                Map brokerInfo = (Map)m;
                                String host = (String)brokerInfo.get((Object)"host").get();
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("  %-12s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, host})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                return;
                            }
                            if (None$.MODULE$.equals(option2)) {
                                throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                            }
                            throw new MatchError(option2);
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        this.zkUtils$1 = zkUtils$1;
                    }
                });
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Exiting due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.getMessage()})));
            }
        }
        finally {
            if ((ZkUtils)zkUtils.elem != null) {
                ((ZkUtils)zkUtils.elem).close();
            }
        }
    }

    private MonitorBrokerInfo$() {
        MODULE$ = this;
        this.zkSessionTimeoutMs = 30000;
        this.zkConnectionTimeoutMs = 30000;
    }
}

