/*
 * Decompiled with CFR 0.152.
 */
package kafka.om;

import kafka.controller.KafkaController$;
import kafka.server.KafkaConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class KafkaCleanZookeeperData$
implements Logging {
    public static final KafkaCleanZookeeperData$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerPath;
    private final String ConfigPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String AdminPath;
    private final String DiskAdapter;
    private ZkUtils zkUtils;
    private KafkaConfig config;
    private String chroot;
    private String zkConnect;
    private int zkSessionTimeoutMs;
    private int zkConnectionTimeoutMs;
    private boolean zkEnableSecureAcls;
    private boolean isDeleteOneNode;
    private String zkDeleteNode;
    private final int argsCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new KafkaCleanZookeeperData$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaCleanZookeeperData$ kafkaCleanZookeeperData$ = this;
        synchronized (kafkaCleanZookeeperData$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerPath() {
        return this.BrokerPath;
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String AdminPath() {
        return this.AdminPath;
    }

    public String DiskAdapter() {
        return this.DiskAdapter;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String chroot() {
        return this.chroot;
    }

    public void chroot_$eq(String x$1) {
        this.chroot = x$1;
    }

    public String zkConnect() {
        return this.zkConnect;
    }

    public void zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void zkSessionTimeoutMs_$eq(int x$1) {
        this.zkSessionTimeoutMs = x$1;
    }

    public int zkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }

    public void zkConnectionTimeoutMs_$eq(int x$1) {
        this.zkConnectionTimeoutMs = x$1;
    }

    public boolean zkEnableSecureAcls() {
        return this.zkEnableSecureAcls;
    }

    public void zkEnableSecureAcls_$eq(boolean x$1) {
        this.zkEnableSecureAcls = x$1;
    }

    public boolean isDeleteOneNode() {
        return this.isDeleteOneNode;
    }

    public void isDeleteOneNode_$eq(boolean x$1) {
        this.isDeleteOneNode = x$1;
    }

    public String zkDeleteNode() {
        return this.zkDeleteNode;
    }

    public void zkDeleteNode_$eq(String x$1) {
        this.zkDeleteNode = x$1;
    }

    public int argsCount() {
        return this.argsCount;
    }

    public void main(String[] args) {
        if (args.length < this.argsCount()) {
            Predef$.MODULE$.println((Object)"ERROR: args count is invalid.");
            System.exit(1);
        }
        if (args.length > this.argsCount()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"agrs4 : ").append((Object)args[4]).toString());
            this.isDeleteOneNode_$eq(true);
            this.zkDeleteNode_$eq(args[4]);
        }
        try {
            Object object;
            try {
                this.zkConnect_$eq(args[0]);
                this.zkSessionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt());
                this.zkConnectionTimeoutMs_$eq(new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt());
                this.zkEnableSecureAcls_$eq(new StringOps(Predef$.MODULE$.augmentString(args[3])).toBoolean());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"agrs : ").append((Object)args[0]).append((Object)" ").append((Object)args[1]).append((Object)" ").append((Object)args[2]).append((Object)" ").append((Object)args[3]).toString());
                this.zkUtils_$eq(this.initZk());
                if (this.isDeleteOneNode()) {
                    this.deleteEphemeralNode(this.zkUtils(), this.zkDeleteNode());
                } else {
                    this.deleteCommonPaths(this.zkUtils());
                }
                object = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                object = this.fatal((Function0<Throwable>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
        }
        finally {
            if (this.zkUtils() != null) {
                this.zkUtils().close();
            }
        }
        System.exit(0);
    }

    private ZkUtils initZk() {
        boolean secureAclsEnabled;
        this.chroot_$eq(this.zkConnect().indexOf("/") > 0 ? this.zkConnect().substring(this.zkConnect().indexOf("/")) : "");
        String zkConnForChrootCreation = "";
        boolean bl = secureAclsEnabled = JaasUtils.isZkSecurityEnabled() && this.zkEnableSecureAcls();
        if (this.zkEnableSecureAcls() && !secureAclsEnabled) {
            throw new SecurityException("zkEnableSecureAcls is true, but the verification of the JAAS login file failed.");
        }
        if (this.chroot().length() > 1) {
            zkConnForChrootCreation = this.zkConnect().substring(0, this.zkConnect().indexOf("/"));
            ZkUtils zkClientForChrootCreation = ZkUtils$.MODULE$.apply(zkConnForChrootCreation, this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
            zkClientForChrootCreation.zkClient().close();
        }
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkConnForChrootCreation, this.zkSessionTimeoutMs(), this.zkConnectionTimeoutMs(), secureAclsEnabled);
        return zkUtils;
    }

    private void deleteCommonPaths(ZkUtils zkUtils) {
        if (this.chroot().length() > 1) {
            System.out.println(new StringBuilder().append((Object)"Delete zookeeper: ").append((Object)this.chroot()).toString());
            zkUtils.deletePathRecursive(this.chroot());
        } else {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumersPath(), this.BrokerPath(), this.ConfigPath(), this.ControllerPath(), this.ControllerEpochPath(), this.AdminPath(), this.DiskAdapter()}))).foreach((Function1)new Serializable(zkUtils){
                public static final long serialVersionUID = 0L;
                private final ZkUtils zkUtils$1;

                public final void apply(String path) {
                    System.out.println(new StringBuilder().append((Object)"Delete zookeeper: ").append((Object)path).toString());
                    this.zkUtils$1.deletePathRecursive(path);
                }
                {
                    this.zkUtils$1 = zkUtils$1;
                }
            });
        }
    }

    private void deleteEphemeralNode(ZkUtils zkUtils, String node) {
        block6: {
            Boolean bl;
            String deleteBrokerId = "";
            String deleteController = "";
            String kafkaRoot = "";
            kafkaRoot = this.chroot().length() > 1 ? this.chroot() : "/kafka";
            deleteBrokerId = new StringBuilder().append((Object)kafkaRoot).append((Object)this.BrokerPath()).append((Object)"/ids").append((Object)"/").append((Object)node).toString();
            deleteController = new StringBuilder().append((Object)kafkaRoot).append((Object)this.ControllerPath()).toString();
            System.out.println(new StringBuilder().append((Object)"Delete zookeeper node: ").append((Object)deleteBrokerId).toString());
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)zkUtils.deletePath(deleteBrokerId));
            }
            catch (Throwable throwable) {
                System.out.println("Get exception when delete node");
                bl = BoxedUnit.UNIT;
            }
            try {
                Option option;
                block9: {
                    Object object;
                    block8: {
                        block7: {
                            option = (Option)zkUtils.readDataMaybeNull(deleteController)._1();
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            String controller = (String)some.x();
                            object = BoxesRunTime.boxToInteger((int)KafkaController$.MODULE$.parseControllerId(controller));
                            break block8;
                        }
                        if (!None$.MODULE$.equals(option)) break block9;
                        System.out.println("controller does not exist");
                        object = BoxedUnit.UNIT;
                    }
                    BoxedUnit controllerId = object;
                    if (controllerId.toString().equals(node)) {
                        System.out.println(new StringBuilder().append((Object)"Delete zookeeper node: ").append((Object)deleteController).toString());
                        zkUtils.deletePath(deleteController);
                    }
                    break block6;
                }
                throw new MatchError((Object)option);
            }
            catch (Throwable throwable) {
                System.out.println("Get exception when delete controller");
            }
        }
    }

    private KafkaCleanZookeeperData$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerPath = "/brokers";
        this.ConfigPath = "/config";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.AdminPath = "/admin";
        this.DiskAdapter = "/adaptive_disk";
        this.zkUtils = null;
        this.config = null;
        this.chroot = "";
        this.zkConnect = "";
        this.zkSessionTimeoutMs = 6000;
        this.zkConnectionTimeoutMs = 6000;
        this.zkEnableSecureAcls = false;
        this.isDeleteOneNode = false;
        this.zkDeleteNode = "";
        this.argsCount = 4;
    }
}

