/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceRouterConvert;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceRouterHolder;
import com.github.xiaoymin.knife4j.spring.gateway.discover.spi.GatewayServiceExcludeService;
import com.github.xiaoymin.knife4j.spring.gateway.spec.v2.OpenAPI2Resource;
import com.github.xiaoymin.knife4j.spring.gateway.utils.PathUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class ServiceDiscoverHandler
implements EnvironmentAware,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoverHandler.class);
    final Knife4jGatewayProperties knife4jGatewayProperties;
    final Set<OpenAPI2Resource> gatewayResources = new TreeSet<OpenAPI2Resource>();
    private Environment environment;
    private ApplicationContext applicationContext;

    public ServiceDiscoverHandler(Knife4jGatewayProperties knife4jGatewayProperties) {
        this.knife4jGatewayProperties = knife4jGatewayProperties;
    }

    private Set<String> getExcludeService(List<String> service) {
        Map excludeServiceMap = this.applicationContext.getBeansOfType(GatewayServiceExcludeService.class);
        HashSet<String> excludeService = new HashSet<String>();
        if (!excludeServiceMap.isEmpty()) {
            for (Map.Entry entry : excludeServiceMap.entrySet()) {
                Set<String> stringSet = ((GatewayServiceExcludeService)entry.getValue()).exclude(this.environment, this.knife4jGatewayProperties, service);
                if (stringSet == null || stringSet.isEmpty()) continue;
                excludeService.addAll(stringSet);
            }
        }
        log.debug("exclude-service-size:{},value:{}", (Object)excludeService.size(), (Object)String.join((CharSequence)",", excludeService));
        return excludeService;
    }

    public void discover(List<String> service) {
        log.debug("service has change ,do discover doc for default route.");
        Set<String> excludeService = this.getExcludeService(service);
        ServiceRouterHolder holder = new ServiceRouterHolder(service, excludeService, this);
        holder.clearService();
        Map routerConvertMap = this.applicationContext.getBeansOfType(ServiceRouterConvert.class);
        ArrayList serviceRouterConverts = new ArrayList(routerConvertMap.values());
        serviceRouterConverts.sort(Comparator.comparing(ServiceRouterConvert::order));
        for (ServiceRouterConvert routerConvert : serviceRouterConverts) {
            routerConvert.process(holder);
        }
    }

    public List<OpenAPI2Resource> getResources(String forwardPath) {
        ArrayList<OpenAPI2Resource> resourceList = new ArrayList<OpenAPI2Resource>();
        Set<OpenAPI2Resource> resources = this.getGatewayResources();
        if (!CollectionUtils.isEmpty(resources)) {
            for (OpenAPI2Resource resource : resources) {
                OpenAPI2Resource copy = resource.copy();
                copy.setContextPath(PathUtils.processContextPath(PathUtils.append(forwardPath, copy.getContextPath())));
                copy.setUrl(PathUtils.append(forwardPath, copy.getUrl()));
                log.debug("api-resources:{}", (Object)copy);
                resourceList.add(copy);
            }
            return resourceList;
        }
        return resourceList;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void add(OpenAPI2Resource resource) {
        this.gatewayResources.add(resource);
    }

    public void remove(String serviceName) {
        log.debug("Service `{}` has been offline, removed", (Object)serviceName);
        this.gatewayResources.removeIf(resource -> resource.getServiceName().equalsIgnoreCase(serviceName));
    }

    public Set<OpenAPI2Resource> getGatewayResources() {
        return this.gatewayResources;
    }
}

