/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpClientBuilder;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpDnsClientBuilder
implements OkHttpClientBuilder {
    private Proxy proxy;
    private Authenticator authenticator;
    private final List<Interceptor> interceptorList = new ArrayList<Interceptor>();
    private Dispatcher dispatcher;
    private ConnectionPool connectionPool;
    private EventListener.Factory eventListenerFactory;
    private Boolean retryOnConnectionFailure;
    private Boolean followRedirects;
    private Long connectTimeout;
    private TimeUnit connectTimeUnit;
    private Long callTimeout;
    private TimeUnit callTimeUnit;
    private Long readTimeout;
    private TimeUnit readTimeUnit;
    private Long writeTimeout;
    private TimeUnit writeTimeUnit;
    private Integer pingInterval;
    private Dns dns;
    private OkHttpClient okHttpClient;

    private OkHttpDnsClientBuilder() {
    }

    public static OkHttpDnsClientBuilder get() {
        return new OkHttpDnsClientBuilder();
    }

    public Dns getDns() {
        return this.dns;
    }

    public void setDns(Dns dns) {
        this.dns = dns;
    }

    @Override
    public OkHttpClient build() {
        this.prepare();
        return this.okHttpClient;
    }

    @Override
    public OkHttpClientBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public OkHttpClientBuilder authenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    @Override
    public OkHttpClientBuilder addInterceptor(Interceptor interceptor) {
        this.interceptorList.add(interceptor);
        return this;
    }

    @Override
    public OkHttpClientBuilder setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    @Override
    public OkHttpClientBuilder setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    @Override
    public OkHttpClientBuilder setEventListenerFactory(EventListener.Factory eventListenerFactory) {
        this.eventListenerFactory = eventListenerFactory;
        return this;
    }

    @Override
    public OkHttpClientBuilder setRetryOnConnectionFailure(Boolean retryOnConnectionFailure) {
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        return this;
    }

    @Override
    public OkHttpClientBuilder setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public OkHttpClientBuilder connectTimeout(Long timeout, TimeUnit unit) {
        this.connectTimeout = timeout;
        this.connectTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder callTimeout(Long timeout, TimeUnit unit) {
        this.callTimeout = timeout;
        this.callTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder readTimeout(Long timeout, TimeUnit unit) {
        this.readTimeout = timeout;
        this.readTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder writeTimeout(Long timeout, TimeUnit unit) {
        this.writeTimeout = timeout;
        this.writeTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder setPingInterval(Integer pingInterval) {
        this.pingInterval = pingInterval;
        return this;
    }

    private synchronized void prepare() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (this.authenticator != null) {
            builder.authenticator(this.authenticator);
        }
        if (this.proxy != null) {
            builder.proxy(this.proxy);
        }
        for (Interceptor interceptor : this.interceptorList) {
            builder.addInterceptor(interceptor);
        }
        if (this.dispatcher != null) {
            builder.dispatcher(this.dispatcher);
        }
        if (this.connectionPool != null) {
            builder.connectionPool(this.connectionPool);
        }
        if (this.eventListenerFactory != null) {
            builder.eventListenerFactory(this.eventListenerFactory);
        }
        if (this.retryOnConnectionFailure != null) {
            builder.setRetryOnConnectionFailure$okhttp(this.retryOnConnectionFailure.booleanValue());
        }
        if (this.followRedirects != null) {
            builder.followRedirects(this.followRedirects.booleanValue());
        }
        if (this.dns != null) {
            builder.dns(this.dns);
        }
        if (this.connectTimeout != null && this.connectTimeUnit != null) {
            builder.connectTimeout(this.connectTimeout.longValue(), this.connectTimeUnit);
        }
        if (this.callTimeout != null && this.callTimeUnit != null) {
            builder.callTimeout(this.callTimeout.longValue(), this.callTimeUnit);
        }
        if (this.readTimeout != null && this.readTimeUnit != null) {
            builder.readTimeout(this.readTimeout.longValue(), this.readTimeUnit);
        }
        if (this.writeTimeout != null && this.writeTimeUnit != null) {
            builder.writeTimeout(this.writeTimeout.longValue(), this.writeTimeUnit);
        }
        if (this.pingInterval != null) {
            builder.setPingInterval$okhttp(this.pingInterval.intValue());
        }
        this.okHttpClient = builder.build();
    }
}

