/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.http.HttpResponse;
import me.chanjar.weixin.common.error.WxErrorException;
import okhttp3.Response;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

public class HttpResponseProxy {
    private CloseableHttpResponse apacheHttpResponse;
    private HttpResponse joddHttpResponse;
    private Response okHttpResponse;

    public HttpResponseProxy(CloseableHttpResponse apacheHttpResponse) {
        this.apacheHttpResponse = apacheHttpResponse;
    }

    public HttpResponseProxy(HttpResponse joddHttpResponse) {
        this.joddHttpResponse = joddHttpResponse;
    }

    public HttpResponseProxy(Response okHttpResponse) {
        this.okHttpResponse = okHttpResponse;
    }

    public String getFileName() throws WxErrorException {
        if (this.apacheHttpResponse != null) {
            return this.getFileName(this.apacheHttpResponse);
        }
        if (this.joddHttpResponse != null) {
            return this.getFileName(this.joddHttpResponse);
        }
        if (this.okHttpResponse != null) {
            return this.getFileName(this.okHttpResponse);
        }
        return null;
    }

    private String getFileName(CloseableHttpResponse response) throws WxErrorException {
        Header[] contentDispositionHeader = response.getHeaders("Content-disposition");
        if (contentDispositionHeader == null || contentDispositionHeader.length == 0) {
            throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d\uff0cContent-disposition\u4e3a\u7a7a");
        }
        return HttpResponseProxy.extractFileNameFromContentString(contentDispositionHeader[0].getValue());
    }

    private String getFileName(HttpResponse response) throws WxErrorException {
        String content = response.header("Content-disposition");
        return HttpResponseProxy.extractFileNameFromContentString(content);
    }

    private String getFileName(Response response) throws WxErrorException {
        String content = response.header("Content-disposition");
        return HttpResponseProxy.extractFileNameFromContentString(content);
    }

    public static String extractFileNameFromContentString(String content) throws WxErrorException {
        if (content == null || content.isEmpty()) {
            throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d\uff0ccontent\u4e3a\u7a7a");
        }
        Pattern pattern = Pattern.compile("filename\\*=utf-8''(.*?)($|;|\\s|,)");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            String encodedFileName = matcher.group(1);
            try {
                return URLDecoder.decode(encodedFileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        pattern = Pattern.compile("filename=\"(.*?)\"");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            return new String(matcher.group(1).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d\uff0cheader\u4fe1\u606f\u6709\u95ee\u9898");
    }
}

