/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.insert;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GeneratedKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.AbstractSQLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.GeneratedKeyToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.ItemsToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.SQLToken;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;

public final class InsertStatement
extends AbstractSQLStatement {
    private final Collection<Column> columns = new LinkedList<Column>();
    private GeneratedKey generatedKey;
    private int columnsListLastPosition;
    private int valuesListLastPosition;

    public InsertStatement() {
        super(SQLType.INSERT);
    }

    public void appendGenerateKeyToken(ShardingRule shardingRule, int parametersSize) {
        if (null != this.generatedKey) {
            return;
        }
        Optional<TableRule> tableRule = shardingRule.tryFindTableRule(this.getTables().getSingleTableName());
        if (!tableRule.isPresent()) {
            return;
        }
        Optional<GeneratedKeyToken> generatedKeysToken = this.findGeneratedKeyToken();
        if (!generatedKeysToken.isPresent()) {
            return;
        }
        ItemsToken valuesToken = new ItemsToken(((GeneratedKeyToken)generatedKeysToken.get()).getBeginPosition());
        if (0 == parametersSize) {
            this.appendGenerateKeyToken(shardingRule, (TableRule)tableRule.get(), valuesToken);
        } else {
            this.appendGenerateKeyToken(shardingRule, (TableRule)tableRule.get(), valuesToken, parametersSize);
        }
        this.getSqlTokens().remove(generatedKeysToken.get());
        this.getSqlTokens().add(valuesToken);
    }

    private void appendGenerateKeyToken(ShardingRule shardingRule, TableRule tableRule, ItemsToken valuesToken) {
        Number generatedKey = shardingRule.generateKey(tableRule.getLogicTable());
        valuesToken.getItems().add(generatedKey.toString());
        this.getConditions().add(new Condition(new Column(tableRule.getGenerateKeyColumn(), tableRule.getLogicTable()), new SQLNumberExpression(generatedKey)), shardingRule);
        this.generatedKey = new GeneratedKey(tableRule.getLogicTable(), -1, generatedKey);
    }

    private void appendGenerateKeyToken(ShardingRule shardingRule, TableRule tableRule, ItemsToken valuesToken, int parametersSize) {
        valuesToken.getItems().add("?");
        this.getConditions().add(new Condition(new Column(tableRule.getGenerateKeyColumn(), tableRule.getLogicTable()), new SQLPlaceholderExpression(parametersSize)), shardingRule);
        this.generatedKey = new GeneratedKey(tableRule.getGenerateKeyColumn(), parametersSize, null);
    }

    private Optional<GeneratedKeyToken> findGeneratedKeyToken() {
        for (SQLToken each : this.getSqlTokens()) {
            if (!(each instanceof GeneratedKeyToken)) continue;
            return Optional.of((Object)((GeneratedKeyToken)each));
        }
        return Optional.absent();
    }

    public Collection<Column> getColumns() {
        return this.columns;
    }

    public GeneratedKey getGeneratedKey() {
        return this.generatedKey;
    }

    public int getColumnsListLastPosition() {
        return this.columnsListLastPosition;
    }

    public int getValuesListLastPosition() {
        return this.valuesListLastPosition;
    }

    public void setGeneratedKey(GeneratedKey generatedKey) {
        this.generatedKey = generatedKey;
    }

    public void setColumnsListLastPosition(int columnsListLastPosition) {
        this.columnsListLastPosition = columnsListLastPosition;
    }

    public void setValuesListLastPosition(int valuesListLastPosition) {
        this.valuesListLastPosition = valuesListLastPosition;
    }

    @Override
    public String toString() {
        return "InsertStatement(columns=" + this.getColumns() + ", generatedKey=" + this.getGeneratedKey() + ", columnsListLastPosition=" + this.getColumnsListLastPosition() + ", valuesListLastPosition=" + this.getValuesListLastPosition() + ")";
    }
}

