/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.orderby;

import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.merger.common.AbstractStreamResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.orderby.OrderByValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.OrderItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class OrderByStreamResultSetMerger
extends AbstractStreamResultSetMerger {
    private final List<OrderItem> orderByItems;
    private final Queue<OrderByValue> orderByValuesQueue;
    private final OrderType nullOrderType;
    private boolean isFirstNext;

    public OrderByStreamResultSetMerger(List<ResultSet> resultSets, List<OrderItem> orderByItems, OrderType nullOrderType) throws SQLException {
        this.orderByItems = orderByItems;
        this.orderByValuesQueue = new PriorityQueue<OrderByValue>(resultSets.size());
        this.nullOrderType = nullOrderType;
        this.orderResultSetsToQueue(resultSets);
        this.isFirstNext = true;
    }

    private void orderResultSetsToQueue(List<ResultSet> resultSets) throws SQLException {
        for (ResultSet each : resultSets) {
            OrderByValue orderByValue = new OrderByValue(each, this.orderByItems, this.nullOrderType);
            if (!orderByValue.next()) continue;
            this.orderByValuesQueue.offer(orderByValue);
        }
        this.setCurrentResultSet(this.orderByValuesQueue.isEmpty() ? resultSets.get(0) : this.orderByValuesQueue.peek().getResultSet());
    }

    @Override
    public boolean next() throws SQLException {
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return true;
        }
        OrderByValue firstOrderByValue = this.orderByValuesQueue.poll();
        if (firstOrderByValue.next()) {
            this.orderByValuesQueue.offer(firstOrderByValue);
        }
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        this.setCurrentResultSet(this.orderByValuesQueue.peek().getResultSet());
        return true;
    }

    protected Queue<OrderByValue> getOrderByValuesQueue() {
        return this.orderByValuesQueue;
    }

    protected OrderType getNullOrderType() {
        return this.nullOrderType;
    }

    protected boolean isFirstNext() {
        return this.isFirstNext;
    }
}

