/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.config.ShardingProperties;
import com.dangdang.ddframe.rdb.sharding.config.ShardingPropertiesConstant;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractDataSourceAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.ShardingContext;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource.MasterSlaveDataSource;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final ShardingProperties shardingProperties;
    private final ExecutorEngine executorEngine;
    private final ShardingContext shardingContext;

    public ShardingDataSource(ShardingRule shardingRule) {
        this(shardingRule, new Properties());
    }

    public ShardingDataSource(ShardingRule shardingRule, Properties props) {
        Preconditions.checkNotNull((Object)shardingRule);
        Preconditions.checkNotNull((Object)props);
        this.shardingProperties = new ShardingProperties(props);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.executorEngine = new ExecutorEngine(executorSize);
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        try {
            this.shardingContext = new ShardingContext(shardingRule, DatabaseType.valueFrom(this.getDatabaseProductName(shardingRule)), this.executorEngine, showSQL);
        }
        catch (SQLException ex) {
            throw new ShardingJdbcException(ex);
        }
    }

    private String getDatabaseProductName(ShardingRule shardingRule) throws SQLException {
        String result = null;
        for (DataSource each : shardingRule.getDataSourceRule().getDataSources()) {
            String databaseProductName;
            if (each instanceof MasterSlaveDataSource) {
                databaseProductName = ((MasterSlaveDataSource)each).getDatabaseProductName();
            } else {
                try (Connection connection = each.getConnection();){
                    databaseProductName = connection.getMetaData().getDatabaseProductName();
                }
            }
            Preconditions.checkState((null == result || result.equals(databaseProductName) ? 1 : 0) != 0, (Object)String.format("Database type inconsistent with '%s' and '%s'", result, databaseProductName));
            result = databaseProductName;
        }
        return result;
    }

    @Override
    public ShardingConnection getConnection() throws SQLException {
        MetricsContext.init(this.shardingProperties);
        return new ShardingConnection(this.shardingContext);
    }

    @Override
    public void close() {
        this.executorEngine.close();
    }
}

