/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.routing.type.direct;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataSourceRule;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.hint.ShardingKey;
import com.dangdang.ddframe.rdb.sharding.routing.type.RoutingEngine;
import com.dangdang.ddframe.rdb.sharding.routing.type.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.routing.type.TableUnit;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectRoutingEngine
implements RoutingEngine {
    private static final Logger log = LoggerFactory.getLogger(DirectRoutingEngine.class);
    private final DataSourceRule dataSourceRule;
    private final DatabaseShardingStrategy databaseShardingStrategy;
    private final SQLType sqlType;

    @Override
    public RoutingResult route() {
        Optional<ShardingValue<?>> shardingValue = HintManagerHolder.getDatabaseShardingValue(new ShardingKey("DB_TABLE_NAME", "DB_COLUMN_NAME"));
        Preconditions.checkState((boolean)shardingValue.isPresent());
        log.debug("Before database sharding only db:{} sharding values: {}", this.dataSourceRule.getDataSourceNames(), shardingValue.get());
        Collection<String> routingDataSources = this.databaseShardingStrategy.doStaticSharding(this.sqlType, this.dataSourceRule.getDataSourceNames(), Collections.singleton(shardingValue.get()));
        Preconditions.checkState((!routingDataSources.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        log.debug("After database sharding only result: {}", routingDataSources);
        RoutingResult result = new RoutingResult();
        for (String each : routingDataSources) {
            result.getTableUnits().getTableUnits().add(new TableUnit(each, "", ""));
        }
        return result;
    }

    @ConstructorProperties(value={"dataSourceRule", "databaseShardingStrategy", "sqlType"})
    public DirectRoutingEngine(DataSourceRule dataSourceRule, DatabaseShardingStrategy databaseShardingStrategy, SQLType sqlType) {
        this.dataSourceRule = dataSourceRule;
        this.databaseShardingStrategy = databaseShardingStrategy;
        this.sqlType = sqlType;
    }
}

