/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.routing.router;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.ShardingContext;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.dangdang.ddframe.rdb.sharding.parsing.SQLJudgeEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.routing.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.routing.SQLRouteResult;
import com.dangdang.ddframe.rdb.sharding.routing.router.SQLRouter;
import com.dangdang.ddframe.rdb.sharding.routing.type.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.routing.type.TableUnit;
import com.dangdang.ddframe.rdb.sharding.routing.type.direct.DirectRoutingEngine;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnparsingSQLRouter
implements SQLRouter {
    private static final Logger log = LoggerFactory.getLogger(UnparsingSQLRouter.class);
    private final ShardingRule shardingRule;

    public UnparsingSQLRouter(ShardingContext shardingContext) {
        this.shardingRule = shardingContext.getShardingRule();
    }

    @Override
    public SQLStatement parse(String logicSQL, int parametersSize) {
        return new SQLJudgeEngine(logicSQL).judge();
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        Timer.Context context = MetricsContext.start("Route SQL");
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        RoutingResult routingResult = new DirectRoutingEngine(this.shardingRule.getDataSourceRule(), this.shardingRule.getDatabaseShardingStrategy(), sqlStatement.getType()).route();
        for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
            result.getExecutionUnits().add(new SQLExecutionUnit(each.getDataSourceName(), logicSQL));
        }
        MetricsContext.stop(context);
        this.logSQLRouteResult(result, parameters);
        return result;
    }

    private void logSQLRouteResult(SQLRouteResult routeResult, List<Object> parameters) {
        log.debug("final route result is {} target", (Object)routeResult.getExecutionUnits().size());
        for (SQLExecutionUnit each : routeResult.getExecutionUnits()) {
            log.debug("{}:{} {}", new Object[]{each.getDataSource(), each.getSql(), parameters});
        }
    }
}

