/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.rewrite;

import com.dangdang.ddframe.rdb.sharding.api.rule.BindingTableRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.ItemsToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetLimitToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountLimitToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.SQLToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.TableToken;
import com.dangdang.ddframe.rdb.sharding.rewrite.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.routing.type.TableUnit;
import com.dangdang.ddframe.rdb.sharding.routing.type.complex.CartesianTableReference;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLRewriteEngine {
    private final ShardingRule shardingRule;
    private final String originalSQL;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final Collection<String> tableNames;
    private final Limit limit;

    public SQLRewriteEngine(ShardingRule shardingRule, String originalSQL, SQLStatement sqlStatement) {
        this.shardingRule = shardingRule;
        this.originalSQL = originalSQL;
        this.sqlTokens.addAll(sqlStatement.getSqlTokens());
        this.tableNames = sqlStatement.getTables().getTableNames();
        this.limit = sqlStatement.getLimit();
    }

    public SQLBuilder rewrite(boolean isRewriteLimit) {
        SQLBuilder result = new SQLBuilder();
        if (this.sqlTokens.isEmpty()) {
            result.appendLiterals(this.originalSQL);
            return result;
        }
        int count = 0;
        this.sortByBeginPosition();
        for (SQLToken each : this.sqlTokens) {
            if (0 == count) {
                result.appendLiterals(this.originalSQL.substring(0, each.getBeginPosition()));
            }
            if (each instanceof TableToken) {
                this.appendTableToken(result, (TableToken)each, count, this.sqlTokens);
            } else if (each instanceof ItemsToken) {
                this.appendItemsToken(result, (ItemsToken)each, count, this.sqlTokens);
            } else if (each instanceof RowCountLimitToken) {
                this.appendLimitRowCount(result, (RowCountLimitToken)each, count, this.sqlTokens, isRewriteLimit);
            } else if (each instanceof OffsetLimitToken) {
                this.appendLimitOffsetToken(result, (OffsetLimitToken)each, count, this.sqlTokens, isRewriteLimit);
            }
            ++count;
        }
        return result;
    }

    private void sortByBeginPosition() {
        Collections.sort(this.sqlTokens, new Comparator<SQLToken>(){

            @Override
            public int compare(SQLToken o1, SQLToken o2) {
                return o1.getBeginPosition() - o2.getBeginPosition();
            }
        });
    }

    private void appendTableToken(SQLBuilder sqlBuilder, TableToken tableToken, int count, List<SQLToken> sqlTokens) {
        String tableName = this.tableNames.contains(tableToken.getTableName()) ? tableToken.getTableName() : tableToken.getOriginalLiterals();
        sqlBuilder.appendTable(tableName);
        int beginPosition = tableToken.getBeginPosition() + tableToken.getOriginalLiterals().length();
        int endPosition = sqlTokens.size() - 1 == count ? this.originalSQL.length() : sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(beginPosition, endPosition));
    }

    private void appendItemsToken(SQLBuilder sqlBuilder, ItemsToken itemsToken, int count, List<SQLToken> sqlTokens) {
        for (String item : itemsToken.getItems()) {
            sqlBuilder.appendLiterals(", ");
            sqlBuilder.appendLiterals(item);
        }
        int beginPosition = itemsToken.getBeginPosition();
        int endPosition = sqlTokens.size() - 1 == count ? this.originalSQL.length() : sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(beginPosition, endPosition));
    }

    private void appendLimitRowCount(SQLBuilder sqlBuilder, RowCountLimitToken rowCountLimitToken, int count, List<SQLToken> sqlTokens, boolean isRewrite) {
        sqlBuilder.appendLiterals(isRewrite ? String.valueOf(rowCountLimitToken.getRowCount() + this.limit.getOffset()) : String.valueOf(rowCountLimitToken.getRowCount()));
        int beginPosition = rowCountLimitToken.getBeginPosition() + String.valueOf(rowCountLimitToken.getRowCount()).length();
        int endPosition = sqlTokens.size() - 1 == count ? this.originalSQL.length() : sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(beginPosition, endPosition));
    }

    private void appendLimitOffsetToken(SQLBuilder sqlBuilder, OffsetLimitToken offsetLimitToken, int count, List<SQLToken> sqlTokens, boolean isRewrite) {
        sqlBuilder.appendLiterals(isRewrite ? "0" : String.valueOf(offsetLimitToken.getOffset()));
        int beginPosition = offsetLimitToken.getBeginPosition() + String.valueOf(offsetLimitToken.getOffset()).length();
        int endPosition = sqlTokens.size() - 1 == count ? this.originalSQL.length() : sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(beginPosition, endPosition));
    }

    public String generateSQL(TableUnit tableUnit, SQLBuilder sqlBuilder) {
        return sqlBuilder.toSQL(this.getTableTokens(tableUnit));
    }

    public String generateSQL(CartesianTableReference cartesianTableReference, SQLBuilder sqlBuilder) {
        return sqlBuilder.toSQL(this.getTableTokens(cartesianTableReference));
    }

    private Map<String, String> getTableTokens(TableUnit tableUnit) {
        HashMap<String, String> tableTokens = new HashMap<String, String>();
        tableTokens.put(tableUnit.getLogicTableName(), tableUnit.getActualTableName());
        Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(tableUnit.getLogicTableName());
        if (bindingTableRule.isPresent()) {
            tableTokens.putAll(this.getBindingTableTokens(tableUnit, (BindingTableRule)bindingTableRule.get()));
        }
        return tableTokens;
    }

    private Map<String, String> getTableTokens(CartesianTableReference cartesianTableReference) {
        HashMap<String, String> tableTokens = new HashMap<String, String>();
        for (TableUnit each : cartesianTableReference.getTableUnits()) {
            tableTokens.put(each.getLogicTableName(), each.getActualTableName());
            Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(each.getLogicTableName());
            if (!bindingTableRule.isPresent()) continue;
            tableTokens.putAll(this.getBindingTableTokens(each, (BindingTableRule)bindingTableRule.get()));
        }
        return tableTokens;
    }

    private Map<String, String> getBindingTableTokens(TableUnit tableUnit, BindingTableRule bindingTableRule) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String eachTable : this.tableNames) {
            if (eachTable.equalsIgnoreCase(tableUnit.getLogicTableName()) || !bindingTableRule.hasLogicTable(eachTable)) continue;
            result.put(eachTable, bindingTableRule.getBindingActualTable(tableUnit.getDataSourceName(), eachTable, tableUnit.getActualTableName()));
        }
        return result;
    }
}

