/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.rewrite;

import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLBuilder {
    private final List<Object> segments;
    private StringBuilder currentSegment;

    public SQLBuilder() {
        this.segments = new LinkedList<Object>();
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public void appendLiterals(String literals) {
        this.currentSegment.append(literals);
    }

    public void appendTable(String tableName) {
        this.segments.add(new TableToken(tableName));
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public String toSQL(Map<String, String> tableTokens) {
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            if (each instanceof TableToken && tableTokens.containsKey(((TableToken)each).tableName)) {
                result.append(tableTokens.get(((TableToken)each).tableName));
                continue;
            }
            result.append(each);
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            if (each instanceof TableToken) {
                result.append(String.format("[Token(%s)]", ((TableToken)each).tableName));
                continue;
            }
            result.append(each);
        }
        return result.toString();
    }

    private SQLBuilder(List<Object> segments) {
        this.segments = segments;
    }

    private class TableToken {
        private final String tableName;

        public String toString() {
            return this.tableName;
        }

        @ConstructorProperties(value={"tableName"})
        public TableToken(String tableName) {
            this.tableName = tableName;
        }
    }
}

