/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select;

import com.dangdang.ddframe.rdb.sharding.constant.AggregationType;
import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GroupBy;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.OrderBy;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.AggregationSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.CommonSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.SelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table.Table;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIdentifierExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPropertyExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatementParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.ItemsToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.TableToken;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSelectParser
implements SQLStatementParser {
    private static final String DERIVED_COUNT_ALIAS = "AVG_DERIVED_COUNT_%s";
    private static final String DERIVED_SUM_ALIAS = "AVG_DERIVED_SUM_%s";
    private static final String ORDER_BY_DERIVED_ALIAS = "ORDER_BY_DERIVED_%s";
    private static final String GROUP_BY_DERIVED_ALIAS = "GROUP_BY_DERIVED_%s";
    private final SQLParser sqlParser;
    private final SelectStatement selectStatement;
    private int parametersIndex;

    public AbstractSelectParser(SQLParser sqlParser) {
        this.sqlParser = sqlParser;
        this.selectStatement = new SelectStatement();
    }

    @Override
    public final SelectStatement parse() {
        this.query();
        this.selectStatement.getOrderByList().addAll(this.parseOrderBy());
        this.customizedSelect();
        this.appendDerivedColumns();
        return this.selectStatement;
    }

    protected void customizedSelect() {
    }

    protected void query() {
        this.sqlParser.accept(DefaultKeyword.SELECT);
        this.parseDistinct();
        this.parseSelectList();
        this.parseFrom();
        this.parseWhere();
        this.parseGroupBy();
        this.queryRest();
    }

    protected final void parseDistinct() {
        if (this.sqlParser.equalAny(DefaultKeyword.DISTINCT, DefaultKeyword.DISTINCTROW, DefaultKeyword.UNION)) {
            this.selectStatement.setDistinct(true);
            this.sqlParser.getLexer().nextToken();
            if (this.hasDistinctOn() && this.sqlParser.equalAny(DefaultKeyword.ON)) {
                this.sqlParser.getLexer().nextToken();
                this.sqlParser.skipParentheses();
            }
        } else if (this.sqlParser.equalAny(DefaultKeyword.ALL)) {
            this.sqlParser.getLexer().nextToken();
        }
    }

    protected boolean hasDistinctOn() {
        return false;
    }

    protected final void parseSelectList() {
        int index = 1;
        do {
            SelectItem selectItem = this.parseSelectItem(index);
            this.selectStatement.getItems().add(selectItem);
            if (selectItem instanceof CommonSelectItem && ((CommonSelectItem)selectItem).isStar()) {
                this.selectStatement.setContainStar(true);
            }
            ++index;
        } while (this.sqlParser.skipIfEqual(Symbol.COMMA));
        this.selectStatement.setSelectListLastPosition(this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length());
    }

    private SelectItem parseSelectItem(int index) {
        this.sqlParser.skipIfEqual(DefaultKeyword.CONNECT_BY_ROOT);
        String literals = this.sqlParser.getLexer().getCurrentToken().getLiterals();
        if (this.sqlParser.equalAny(Symbol.STAR) || Symbol.STAR.getLiterals().equals(SQLUtil.getExactlyValue(literals))) {
            this.sqlParser.getLexer().nextToken();
            return new CommonSelectItem(Symbol.STAR.getLiterals(), this.sqlParser.parseAlias(), true);
        }
        if (this.sqlParser.skipIfEqual(DefaultKeyword.MAX, DefaultKeyword.MIN, DefaultKeyword.SUM, DefaultKeyword.AVG, DefaultKeyword.COUNT)) {
            return new AggregationSelectItem(this.sqlParser.skipParentheses(), this.sqlParser.parseAlias(), index, AggregationType.valueOf(literals.toUpperCase()));
        }
        StringBuilder expression = new StringBuilder();
        while (!(this.sqlParser.equalAny(DefaultKeyword.AS) || this.sqlParser.equalAny(Symbol.COMMA) || this.sqlParser.equalAny(DefaultKeyword.FROM) || this.sqlParser.equalAny(Assist.END))) {
            String value = this.sqlParser.getLexer().getCurrentToken().getLiterals();
            int position = this.sqlParser.getLexer().getCurrentToken().getEndPosition() - value.length();
            expression.append(value);
            this.sqlParser.getLexer().nextToken();
            if (!this.sqlParser.equalAny(Symbol.DOT)) continue;
            this.selectStatement.getSqlTokens().add(new TableToken(position, value));
        }
        return new CommonSelectItem(SQLUtil.getExactlyValue(expression.toString()), this.sqlParser.parseAlias(), false);
    }

    protected void queryRest() {
        if (this.sqlParser.equalAny(DefaultKeyword.UNION, DefaultKeyword.EXCEPT, DefaultKeyword.INTERSECT, DefaultKeyword.MINUS)) {
            throw new SQLParsingUnsupportedException(this.sqlParser.getLexer().getCurrentToken().getType());
        }
    }

    protected final void parseWhere() {
        if (this.selectStatement.getTables().isEmpty()) {
            return;
        }
        this.sqlParser.parseWhere(this.selectStatement);
        this.parametersIndex = this.sqlParser.getParametersIndex();
    }

    public final List<OrderBy> parseOrderBy() {
        if (!this.sqlParser.skipIfEqual(DefaultKeyword.ORDER)) {
            return Collections.emptyList();
        }
        LinkedList<OrderBy> result = new LinkedList<OrderBy>();
        this.sqlParser.skipIfEqual(DefaultKeyword.SIBLINGS);
        this.sqlParser.accept(DefaultKeyword.BY);
        do {
            Optional<OrderBy> orderBy;
            if (!(orderBy = this.parseSelectOrderByItem()).isPresent()) continue;
            result.add((OrderBy)orderBy.get());
        } while (this.sqlParser.skipIfEqual(Symbol.COMMA));
        return result;
    }

    protected Optional<OrderBy> parseSelectOrderByItem() {
        OrderBy result;
        SQLExpression sqlExpression = this.sqlParser.parseExpression(this.selectStatement);
        OrderType orderByType = OrderType.ASC;
        if (this.sqlParser.skipIfEqual(DefaultKeyword.ASC)) {
            orderByType = OrderType.ASC;
        } else if (this.sqlParser.skipIfEqual(DefaultKeyword.DESC)) {
            orderByType = OrderType.DESC;
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            result = new OrderBy(((SQLNumberExpression)sqlExpression).getNumber().intValue(), orderByType);
        } else if (sqlExpression instanceof SQLIdentifierExpression) {
            result = new OrderBy(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName())));
        } else if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            result = new OrderBy(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()) + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName())));
        } else {
            return Optional.absent();
        }
        return Optional.of((Object)result);
    }

    protected void parseGroupBy() {
        if (this.sqlParser.skipIfEqual(DefaultKeyword.GROUP)) {
            this.sqlParser.accept(DefaultKeyword.BY);
            while (true) {
                this.addGroupByItem(this.sqlParser.parseExpression(this.selectStatement));
                if (!this.sqlParser.equalAny(Symbol.COMMA)) break;
                this.sqlParser.getLexer().nextToken();
            }
            while (this.sqlParser.equalAny(DefaultKeyword.WITH) || this.sqlParser.getLexer().getCurrentToken().getLiterals().equalsIgnoreCase("ROLLUP")) {
                this.sqlParser.getLexer().nextToken();
            }
            if (this.sqlParser.skipIfEqual(DefaultKeyword.HAVING)) {
                throw new UnsupportedOperationException("Cannot support Having");
            }
        } else if (this.sqlParser.skipIfEqual(DefaultKeyword.HAVING)) {
            throw new UnsupportedOperationException("Cannot support Having");
        }
    }

    protected final void addGroupByItem(SQLExpression sqlExpression) {
        GroupBy groupBy;
        OrderType orderByType = OrderType.ASC;
        if (this.sqlParser.equalAny(DefaultKeyword.ASC)) {
            this.sqlParser.getLexer().nextToken();
        } else if (this.sqlParser.skipIfEqual(DefaultKeyword.DESC)) {
            orderByType = OrderType.DESC;
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            groupBy = new GroupBy((Optional<String>)Optional.of((Object)SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName())), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner() + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName()))));
        } else if (sqlExpression instanceof SQLIdentifierExpression) {
            SQLIdentifierExpression sqlIdentifierExpression = (SQLIdentifierExpression)sqlExpression;
            groupBy = new GroupBy((Optional<String>)Optional.absent(), SQLUtil.getExactlyValue(sqlIdentifierExpression.getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(sqlIdentifierExpression.getName())));
        } else {
            return;
        }
        this.selectStatement.getGroupByList().add(groupBy);
    }

    private Optional<String> getAlias(String name) {
        if (this.selectStatement.isContainStar()) {
            return Optional.absent();
        }
        String rawName = SQLUtil.getExactlyValue(name);
        for (SelectItem each : this.selectStatement.getItems()) {
            if (rawName.equalsIgnoreCase(SQLUtil.getExactlyValue(each.getExpression()))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase((String)each.getAlias().orNull())) continue;
            return Optional.of((Object)rawName);
        }
        return Optional.absent();
    }

    public final void parseFrom() {
        if (this.sqlParser.skipIfEqual(DefaultKeyword.FROM)) {
            this.parseTable();
        }
    }

    public void parseTable() {
        if (this.sqlParser.equalAny(Symbol.LEFT_PAREN)) {
            throw new UnsupportedOperationException("Cannot support subquery");
        }
        this.parseTableFactor();
        this.parseJoinTable();
    }

    protected final void parseTableFactor() {
        int beginPosition = this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length();
        String literals = this.sqlParser.getLexer().getCurrentToken().getLiterals();
        this.sqlParser.getLexer().nextToken();
        if (this.sqlParser.skipIfEqual(Symbol.DOT)) {
            this.sqlParser.getLexer().nextToken();
            this.sqlParser.parseAlias();
            return;
        }
        this.selectStatement.getSqlTokens().add(new TableToken(beginPosition, literals));
        this.selectStatement.getTables().add(new Table(SQLUtil.getExactlyValue(literals), this.sqlParser.parseAlias()));
    }

    protected void parseJoinTable() {
        if (this.sqlParser.skipJoin()) {
            this.parseTable();
            if (this.sqlParser.skipIfEqual(DefaultKeyword.ON)) {
                do {
                    this.parseTableCondition(this.sqlParser.getLexer().getCurrentToken().getEndPosition());
                    this.sqlParser.accept(Symbol.EQ);
                    this.parseTableCondition(this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length());
                } while (this.sqlParser.skipIfEqual(DefaultKeyword.AND));
            } else if (this.sqlParser.skipIfEqual(DefaultKeyword.USING)) {
                this.sqlParser.skipParentheses();
            }
            this.parseJoinTable();
        }
    }

    private void parseTableCondition(int startPosition) {
        SQLExpression sqlExpression = this.sqlParser.parseExpression();
        if (!(sqlExpression instanceof SQLPropertyExpression)) {
            return;
        }
        SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
        if (this.selectStatement.getTables().getTableNames().contains(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()))) {
            this.selectStatement.getSqlTokens().add(new TableToken(startPosition, sqlPropertyExpression.getOwner().getName()));
        }
    }

    private void appendDerivedColumns() {
        ItemsToken itemsToken = new ItemsToken(this.selectStatement.getSelectListLastPosition());
        this.appendAvgDerivedColumns(itemsToken);
        this.appendOrderByDerivedColumns(itemsToken);
        this.appendGroupByDerivedColumns(itemsToken);
        if (!itemsToken.getItems().isEmpty()) {
            this.selectStatement.getSqlTokens().add(itemsToken);
        }
    }

    private void appendAvgDerivedColumns(ItemsToken itemsToken) {
        int derivedColumnOffset = 0;
        for (SelectItem each : this.selectStatement.getItems()) {
            if (!(each instanceof AggregationSelectItem) || AggregationType.AVG != ((AggregationSelectItem)each).getAggregationType()) continue;
            AggregationSelectItem avgItem = (AggregationSelectItem)each;
            String countAlias = String.format(DERIVED_COUNT_ALIAS, derivedColumnOffset);
            AggregationSelectItem countItem = new AggregationSelectItem(avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)countAlias), -1, AggregationType.COUNT);
            String sumAlias = String.format(DERIVED_SUM_ALIAS, derivedColumnOffset);
            AggregationSelectItem sumItem = new AggregationSelectItem(avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)sumAlias), -1, AggregationType.SUM);
            avgItem.getDerivedAggregationSelectItems().add(countItem);
            avgItem.getDerivedAggregationSelectItems().add(sumItem);
            itemsToken.getItems().add(countItem.getExpression() + " AS " + countAlias + " ");
            itemsToken.getItems().add(sumItem.getExpression() + " AS " + sumAlias + " ");
            ++derivedColumnOffset;
        }
    }

    private void appendOrderByDerivedColumns(ItemsToken itemsToken) {
        int derivedColumnOffset = 0;
        for (OrderBy each : this.selectStatement.getOrderByList()) {
            if (this.isContainItem(each)) continue;
            String orderByExpression = each.getOwner().isPresent() ? (String)each.getOwner().get() + "." + (String)each.getName().get() : (String)each.getName().get();
            String alias = String.format(ORDER_BY_DERIVED_ALIAS, derivedColumnOffset++);
            each.setAlias((Optional<String>)Optional.of((Object)alias));
            itemsToken.getItems().add(orderByExpression + " AS " + alias + " ");
        }
    }

    private void appendGroupByDerivedColumns(ItemsToken itemsToken) {
        int derivedColumnOffset = 0;
        for (GroupBy each : this.selectStatement.getGroupByList()) {
            if (this.isContainItem(each)) continue;
            String groupByExpression = each.getOwner().isPresent() ? (String)each.getOwner().get() + "." + each.getName() : each.getName();
            String alias = String.format(GROUP_BY_DERIVED_ALIAS, derivedColumnOffset++);
            each.setAlias((Optional<String>)Optional.of((Object)alias));
            itemsToken.getItems().add(groupByExpression + " AS " + alias + " ");
        }
    }

    private boolean isContainItem(OrderBy orderBy) {
        if (this.selectStatement.isContainStar()) {
            return true;
        }
        for (SelectItem each : this.selectStatement.getItems()) {
            if (orderBy.getIndex().isPresent()) {
                return true;
            }
            if (each.getAlias().isPresent() && orderBy.getAlias().isPresent() && ((String)each.getAlias().get()).equalsIgnoreCase((String)orderBy.getAlias().get())) {
                return true;
            }
            if (!orderBy.getQualifiedName().isPresent() || !each.getExpression().equalsIgnoreCase((String)orderBy.getQualifiedName().get())) continue;
            return true;
        }
        return false;
    }

    private boolean isContainItem(GroupBy groupBy) {
        if (this.selectStatement.isContainStar()) {
            return true;
        }
        for (SelectItem each : this.selectStatement.getItems()) {
            if (each.getAlias().isPresent() && groupBy.getAlias().isPresent() && ((String)each.getAlias().get()).equalsIgnoreCase((String)groupBy.getAlias().get())) {
                return true;
            }
            if (!groupBy.getQualifiedName().isPresent() || !each.getExpression().equalsIgnoreCase((String)groupBy.getQualifiedName().get())) continue;
            return true;
        }
        return false;
    }

    protected SQLParser getSqlParser() {
        return this.sqlParser;
    }

    protected SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    protected int getParametersIndex() {
        return this.parametersIndex;
    }

    public void setParametersIndex(int parametersIndex) {
        this.parametersIndex = parametersIndex;
    }
}

