/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.insert;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.TokenType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GeneratedKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatementParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.GeneratedKeyToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.ItemsToken;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;

public abstract class AbstractInsertParser
implements SQLStatementParser {
    private final SQLParser sqlParser;
    private final ShardingRule shardingRule;
    private final InsertStatement insertStatement;
    private int generateKeyColumnIndex = -1;

    public AbstractInsertParser(ShardingRule shardingRule, SQLParser sqlParser) {
        this.sqlParser = sqlParser;
        this.shardingRule = shardingRule;
        this.insertStatement = new InsertStatement();
    }

    @Override
    public final InsertStatement parse() {
        this.sqlParser.getLexer().nextToken();
        this.parseInto();
        this.parseColumns();
        if (this.sqlParser.equalAny(DefaultKeyword.SELECT, Symbol.LEFT_PAREN)) {
            throw new UnsupportedOperationException("Cannot support subquery");
        }
        if (this.getValuesKeywords().contains(this.sqlParser.getLexer().getCurrentToken().getType())) {
            this.parseValues();
        } else if (this.getCustomizedInsertKeywords().contains(this.sqlParser.getLexer().getCurrentToken().getType())) {
            this.parseCustomizedInsert();
        }
        this.appendGenerateKey();
        return this.insertStatement;
    }

    protected Set<TokenType> getUnsupportedKeywords() {
        return Collections.emptySet();
    }

    private void parseInto() {
        if (this.getUnsupportedKeywords().contains(this.sqlParser.getLexer().getCurrentToken().getType())) {
            throw new SQLParsingUnsupportedException(this.sqlParser.getLexer().getCurrentToken().getType());
        }
        this.sqlParser.skipUntil(DefaultKeyword.INTO);
        this.sqlParser.getLexer().nextToken();
        this.sqlParser.parseSingleTable(this.insertStatement);
        this.skipBetweenTableAndValues();
    }

    private void skipBetweenTableAndValues() {
        while (this.getSkippedKeywordsBetweenTableAndValues().contains(this.sqlParser.getLexer().getCurrentToken().getType())) {
            this.sqlParser.getLexer().nextToken();
            if (!this.sqlParser.equalAny(Symbol.LEFT_PAREN)) continue;
            this.sqlParser.skipParentheses();
        }
    }

    protected Set<TokenType> getSkippedKeywordsBetweenTableAndValues() {
        return Collections.emptySet();
    }

    private void parseColumns() {
        LinkedList<Column> result = new LinkedList<Column>();
        if (this.sqlParser.equalAny(Symbol.LEFT_PAREN)) {
            String tableName = this.insertStatement.getTables().getSingleTableName();
            Optional<String> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
            int count = 0;
            do {
                this.sqlParser.getLexer().nextToken();
                String columnName = SQLUtil.getExactlyValue(this.sqlParser.getLexer().getCurrentToken().getLiterals());
                result.add(new Column(columnName, tableName));
                this.sqlParser.getLexer().nextToken();
                if (generateKeyColumn.isPresent() && ((String)generateKeyColumn.get()).equalsIgnoreCase(columnName)) {
                    this.generateKeyColumnIndex = count;
                }
                ++count;
            } while (!this.sqlParser.equalAny(Symbol.RIGHT_PAREN) && !this.sqlParser.equalAny(Assist.END));
            this.insertStatement.setColumnsListLastPosition(this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length());
            this.sqlParser.getLexer().nextToken();
        }
        this.insertStatement.getColumns().addAll(result);
    }

    protected Set<TokenType> getValuesKeywords() {
        return Sets.newHashSet((Object[])new TokenType[]{DefaultKeyword.VALUES});
    }

    private void parseValues() {
        boolean parsed = false;
        do {
            if (parsed) {
                throw new UnsupportedOperationException("Cannot support multiple insert");
            }
            this.sqlParser.getLexer().nextToken();
            this.sqlParser.accept(Symbol.LEFT_PAREN);
            LinkedList<SQLExpression> sqlExpressions = new LinkedList<SQLExpression>();
            do {
                sqlExpressions.add(this.sqlParser.parseExpression());
            } while (this.sqlParser.skipIfEqual(Symbol.COMMA));
            this.insertStatement.setValuesListLastPosition(this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length());
            int count = 0;
            for (Column each : this.insertStatement.getColumns()) {
                SQLExpression sqlExpression = (SQLExpression)sqlExpressions.get(count);
                this.insertStatement.getConditions().add(new Condition(each, sqlExpression), this.getShardingRule());
                if (this.generateKeyColumnIndex == count) {
                    this.insertStatement.setGeneratedKey(this.createGeneratedKey(each, sqlExpression));
                }
                ++count;
            }
            this.sqlParser.accept(Symbol.RIGHT_PAREN);
            parsed = true;
        } while (this.sqlParser.equalAny(Symbol.COMMA));
    }

    private GeneratedKey createGeneratedKey(Column column, SQLExpression sqlExpression) {
        GeneratedKey result;
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            result = new GeneratedKey(column.getName(), ((SQLPlaceholderExpression)sqlExpression).getIndex(), null);
        } else if (sqlExpression instanceof SQLNumberExpression) {
            result = new GeneratedKey(column.getName(), -1, ((SQLNumberExpression)sqlExpression).getNumber());
        } else {
            throw new ShardingJdbcException("Generated key only support number.", new Object[0]);
        }
        return result;
    }

    protected Set<TokenType> getCustomizedInsertKeywords() {
        return Collections.emptySet();
    }

    protected void parseCustomizedInsert() {
    }

    private void appendGenerateKey() {
        String tableName = this.insertStatement.getTables().getSingleTableName();
        Optional<String> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
        if (!generateKeyColumn.isPresent() || null != this.insertStatement.getGeneratedKey()) {
            return;
        }
        ItemsToken columnsToken = new ItemsToken(this.insertStatement.getColumnsListLastPosition());
        columnsToken.getItems().add((String)generateKeyColumn.get());
        this.insertStatement.getSqlTokens().add(columnsToken);
        this.insertStatement.getSqlTokens().add(new GeneratedKeyToken(this.insertStatement.getValuesListLastPosition()));
    }

    protected SQLParser getSqlParser() {
        return this.sqlParser;
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected InsertStatement getInsertStatement() {
        return this.insertStatement;
    }

    protected int getGenerateKeyColumnIndex() {
        return this.generateKeyColumnIndex;
    }
}

