/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.sqlserver.SQLServerKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.sqlserver.SQLServerLexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.OffsetLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.RowCountLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Top;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.SelectStatement;

public final class SQLServerParser
extends SQLParser {
    public SQLServerParser(String sql, ShardingRule shardingRule) {
        super(new SQLServerLexer(sql), shardingRule);
        this.getLexer().nextToken();
    }

    public Top parseTop() {
        return null;
    }

    protected void skipOutput() {
        if (this.equalAny(SQLServerKeyword.OUTPUT)) {
            throw new SQLParsingUnsupportedException(SQLServerKeyword.OUTPUT);
        }
    }

    public void parseOffset(SelectStatement selectStatement) {
        Limit limit;
        int offset;
        this.getLexer().nextToken();
        int offsetIndex = -1;
        if (this.equalAny(Literals.INT)) {
            offset = Integer.parseInt(this.getLexer().getCurrentToken().getLiterals());
        } else if (this.equalAny(Symbol.QUESTION)) {
            offsetIndex = this.getParametersIndex();
            offset = -1;
            this.setParametersIndex(offsetIndex + 1);
        } else {
            throw new SQLParsingException(this.getLexer());
        }
        this.getLexer().nextToken();
        if (this.skipIfEqual(DefaultKeyword.FETCH)) {
            int rowCount;
            this.getLexer().nextToken();
            int rowCountIndex = -1;
            this.getLexer().nextToken();
            if (this.equalAny(Literals.INT)) {
                rowCount = Integer.parseInt(this.getLexer().getCurrentToken().getLiterals());
            } else if (this.equalAny(Symbol.QUESTION)) {
                rowCountIndex = this.getParametersIndex();
                rowCount = -1;
                this.setParametersIndex(rowCountIndex + 1);
            } else {
                throw new SQLParsingException(this.getLexer());
            }
            this.getLexer().nextToken();
            this.getLexer().nextToken();
            limit = new Limit(new OffsetLimit(offset, offsetIndex), new RowCountLimit(rowCount, rowCountIndex));
        } else {
            limit = new Limit(new OffsetLimit(offset, offsetIndex));
        }
        selectStatement.setLimit(limit);
    }
}

