/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.postgresql.PostgreSQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.OffsetLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.RowCountLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.AbstractSelectParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetLimitToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountLimitToken;
import com.dangdang.ddframe.rdb.sharding.util.NumberUtil;

public class PostgreSQLSelectParser
extends AbstractSelectParser {
    public PostgreSQLSelectParser(SQLParser sqlParser) {
        super(sqlParser);
    }

    @Override
    public void query() {
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.SELECT)) {
            this.parseDistinct();
            this.parseSelectList();
            if (this.getSqlParser().skipIfEqual(DefaultKeyword.INTO)) {
                this.getSqlParser().skipIfEqual(PostgreSQLKeyword.TEMPORARY, PostgreSQLKeyword.TEMP, PostgreSQLKeyword.UNLOGGED);
                this.getSqlParser().skipIfEqual(DefaultKeyword.TABLE);
            }
        }
        this.parseFrom();
        this.parseWhere();
        this.parseGroupBy();
        if (this.getSqlParser().equalAny(PostgreSQLKeyword.WINDOW)) {
            throw new SQLParsingUnsupportedException(PostgreSQLKeyword.WINDOW);
        }
        this.getSelectStatement().getOrderByList().addAll(this.parseOrderBy());
        this.parseLimit();
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.FETCH)) {
            throw new SQLParsingUnsupportedException(DefaultKeyword.FETCH);
        }
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.FOR)) {
            this.getSqlParser().skipIfEqual(DefaultKeyword.UPDATE, PostgreSQLKeyword.SHARE);
            if (this.getSqlParser().equalAny(PostgreSQLKeyword.OF)) {
                throw new SQLParsingUnsupportedException(PostgreSQLKeyword.OF);
            }
            this.getSqlParser().skipIfEqual(PostgreSQLKeyword.NOWAIT);
        }
        this.queryRest();
    }

    private void parseLimit() {
        int rowCount = -1;
        int offset = -1;
        int rowCountParameterIndex = -1;
        int offsetParameterIndex = -1;
        boolean hasLimit = false;
        boolean hasOffset = false;
        while (true) {
            int parameterIndex = this.getParametersIndex();
            if (this.getSqlParser().skipIfEqual(PostgreSQLKeyword.LIMIT)) {
                hasLimit = true;
                int valueBeginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
                if (this.getSqlParser().equalAny(DefaultKeyword.ALL)) {
                    this.getSqlParser().getLexer().nextToken();
                    continue;
                }
                if (this.getSqlParser().equalAny(Literals.INT, Literals.FLOAT)) {
                    rowCount = NumberUtil.roundHalfUp(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
                    this.getSelectStatement().getSqlTokens().add(new RowCountLimitToken(valueBeginPosition -= (rowCount + "").length(), rowCount));
                } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
                    rowCountParameterIndex = parameterIndex++;
                    this.setParametersIndex(parameterIndex);
                    rowCount = -1;
                } else {
                    throw new SQLParsingException(this.getSqlParser().getLexer());
                }
                this.getSqlParser().getLexer().nextToken();
                continue;
            }
            if (!this.getSqlParser().skipIfEqual(PostgreSQLKeyword.OFFSET)) break;
            hasOffset = true;
            int offsetBeginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
            if (this.getSqlParser().equalAny(Literals.INT, Literals.FLOAT)) {
                offset = NumberUtil.roundHalfUp(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
                this.getSelectStatement().getSqlTokens().add(new OffsetLimitToken(offsetBeginPosition -= (offset + "").length(), offset));
            } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
                offsetParameterIndex = parameterIndex++;
                this.setParametersIndex(parameterIndex);
                offset = -1;
            } else {
                throw new SQLParsingException(this.getSqlParser().getLexer());
            }
            this.getSqlParser().getLexer().nextToken();
            this.getSqlParser().skipIfEqual(PostgreSQLKeyword.ROW, PostgreSQLKeyword.ROWS);
        }
        if (hasLimit || hasOffset) {
            Limit limit = hasOffset && hasLimit ? new Limit(new OffsetLimit(offset, offsetParameterIndex), new RowCountLimit(rowCount, rowCountParameterIndex)) : new Limit(new RowCountLimit(rowCount, rowCountParameterIndex));
            this.getSelectStatement().setLimit(limit);
        }
    }

    @Override
    protected boolean hasDistinctOn() {
        return true;
    }
}

