/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.oracle.OracleKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.MySQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.AbstractSelectParser;

public class MySQLSelectParser
extends AbstractSelectParser {
    public MySQLSelectParser(SQLParser sqlParser) {
        super(sqlParser);
    }

    @Override
    public void query() {
        if (this.getSqlParser().equalAny(DefaultKeyword.SELECT)) {
            this.getSqlParser().getLexer().nextToken();
            this.parseDistinct();
            this.getSqlParser().skipAll(MySQLKeyword.HIGH_PRIORITY, DefaultKeyword.STRAIGHT_JOIN, MySQLKeyword.SQL_SMALL_RESULT, MySQLKeyword.SQL_BIG_RESULT, MySQLKeyword.SQL_BUFFER_RESULT, MySQLKeyword.SQL_CACHE, MySQLKeyword.SQL_NO_CACHE, MySQLKeyword.SQL_CALC_FOUND_ROWS);
            this.parseSelectList();
            this.skipToFrom();
        }
        this.parseFrom();
        this.parseWhere();
        this.parseGroupBy();
        this.getSelectStatement().getOrderByList().addAll(this.parseOrderBy());
        this.parseLimit();
        if (this.getSqlParser().equalAny(DefaultKeyword.PROCEDURE)) {
            throw new SQLParsingUnsupportedException(this.getSqlParser().getLexer().getCurrentToken().getType());
        }
        this.queryRest();
    }

    private void parseLimit() {
        if (this.getSqlParser().equalAny(MySQLKeyword.LIMIT)) {
            this.getSelectStatement().setLimit(((MySQLParser)this.getSqlParser()).parseLimit(this.getSelectStatement(), this.getParametersIndex()));
        }
    }

    private void skipToFrom() {
        while (!this.getSqlParser().equalAny(DefaultKeyword.FROM) && !this.getSqlParser().equalAny(Assist.END)) {
            this.getSqlParser().getLexer().nextToken();
        }
    }

    @Override
    protected void parseJoinTable() {
        if (this.getSqlParser().equalAny(DefaultKeyword.USING)) {
            return;
        }
        if (this.getSqlParser().equalAny(DefaultKeyword.USE)) {
            this.getSqlParser().getLexer().nextToken();
            this.parseIndexHint();
        }
        if (this.getSqlParser().equalAny(OracleKeyword.IGNORE)) {
            this.getSqlParser().getLexer().nextToken();
            this.parseIndexHint();
        }
        if (this.getSqlParser().equalAny(OracleKeyword.FORCE)) {
            this.getSqlParser().getLexer().nextToken();
            this.parseIndexHint();
        }
        super.parseJoinTable();
    }

    private void parseIndexHint() {
        if (this.getSqlParser().equalAny(DefaultKeyword.INDEX)) {
            this.getSqlParser().getLexer().nextToken();
        } else {
            this.getSqlParser().accept(DefaultKeyword.KEY);
        }
        if (this.getSqlParser().equalAny(DefaultKeyword.FOR)) {
            this.getSqlParser().getLexer().nextToken();
            if (this.getSqlParser().equalAny(DefaultKeyword.JOIN)) {
                this.getSqlParser().getLexer().nextToken();
            } else if (this.getSqlParser().equalAny(DefaultKeyword.ORDER)) {
                this.getSqlParser().getLexer().nextToken();
                this.getSqlParser().accept(DefaultKeyword.BY);
            } else {
                this.getSqlParser().accept(DefaultKeyword.GROUP);
                this.getSqlParser().accept(DefaultKeyword.BY);
            }
        }
        this.getSqlParser().skipParentheses();
    }
}

