/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLLexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.OffsetLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.RowCountLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetLimitToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountLimitToken;

public final class MySQLParser
extends SQLParser {
    public MySQLParser(String sql, ShardingRule shardingRule) {
        super(new MySQLLexer(sql), shardingRule);
        this.getLexer().nextToken();
    }

    public Limit parseLimit(SQLStatement sqlStatement, int parametersIndex) {
        int value;
        this.skipIfEqual(MySQLKeyword.LIMIT);
        int valueIndex = -1;
        int valueBeginPosition = this.getLexer().getCurrentToken().getEndPosition();
        boolean isParameterForValue = false;
        if (this.equalAny(Literals.INT)) {
            value = Integer.parseInt(this.getLexer().getCurrentToken().getLiterals());
            valueBeginPosition -= (value + "").length();
        } else if (this.equalAny(Symbol.QUESTION)) {
            valueIndex = parametersIndex;
            value = -1;
            --valueBeginPosition;
            isParameterForValue = true;
        } else {
            throw new SQLParsingException(this.getLexer());
        }
        this.getLexer().nextToken();
        if (this.skipIfEqual(Symbol.COMMA)) {
            return this.getLimitWithComma(sqlStatement, parametersIndex, valueIndex, valueBeginPosition, value, isParameterForValue);
        }
        if (this.skipIfEqual(MySQLKeyword.OFFSET)) {
            return this.getLimitWithOffset(sqlStatement, parametersIndex, valueIndex, valueBeginPosition, value, isParameterForValue);
        }
        if (!isParameterForValue) {
            sqlStatement.getSqlTokens().add(new RowCountLimitToken(valueBeginPosition, value));
        }
        return new Limit(new RowCountLimit(value, valueIndex));
    }

    private Limit getLimitWithComma(SQLStatement sqlStatement, int parametersIndex, int valueIndex, int valueBeginPosition, int value, boolean isParameterForValue) {
        int rowCount;
        int rowCountBeginPosition = this.getLexer().getCurrentToken().getEndPosition();
        int rowCountIndex = -1;
        boolean isParameterForRowCount = false;
        if (this.equalAny(Literals.INT)) {
            rowCount = Integer.parseInt(this.getLexer().getCurrentToken().getLiterals());
            rowCountBeginPosition -= (rowCount + "").length();
        } else if (this.equalAny(Symbol.QUESTION)) {
            rowCountIndex = -1 == valueIndex ? parametersIndex : valueIndex + 1;
            rowCount = -1;
            --rowCountBeginPosition;
            isParameterForRowCount = true;
        } else {
            throw new SQLParsingException(this.getLexer());
        }
        this.getLexer().nextToken();
        if (!isParameterForValue) {
            sqlStatement.getSqlTokens().add(new OffsetLimitToken(valueBeginPosition, value));
        }
        if (!isParameterForRowCount) {
            sqlStatement.getSqlTokens().add(new RowCountLimitToken(rowCountBeginPosition, rowCount));
        }
        return new Limit(new OffsetLimit(value, valueIndex), new RowCountLimit(rowCount, rowCountIndex));
    }

    private Limit getLimitWithOffset(SQLStatement sqlStatement, int parametersIndex, int valueIndex, int valueBeginPosition, int value, boolean isParameterForValue) {
        int offset;
        int offsetBeginPosition = this.getLexer().getCurrentToken().getEndPosition();
        int offsetIndex = -1;
        boolean isParameterForOffset = false;
        if (this.equalAny(Literals.INT)) {
            offset = Integer.parseInt(this.getLexer().getCurrentToken().getLiterals());
            offsetBeginPosition -= (offset + "").length();
        } else if (this.equalAny(Symbol.QUESTION)) {
            offsetIndex = -1 == valueIndex ? parametersIndex : valueIndex + 1;
            offset = -1;
            --offsetBeginPosition;
            isParameterForOffset = true;
        } else {
            throw new SQLParsingException(this.getLexer());
        }
        this.getLexer().nextToken();
        if (!isParameterForOffset) {
            sqlStatement.getSqlTokens().add(new OffsetLimitToken(offsetBeginPosition, offset));
        }
        if (!isParameterForValue) {
            sqlStatement.getSqlTokens().add(new RowCountLimitToken(valueBeginPosition, value));
        }
        return new Limit(new OffsetLimit(offset, offsetIndex), new RowCountLimit(value, valueIndex));
    }
}

