/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit;

import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.OffsetLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.RowCountLimit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.util.NumberUtil;
import java.beans.ConstructorProperties;
import java.util.List;

public final class Limit {
    private OffsetLimit offsetLimit;
    private RowCountLimit rowCountLimit;

    public Limit(RowCountLimit rowCount) {
        this.rowCountLimit = rowCount;
    }

    public Limit(OffsetLimit offsetLimit) {
        this.offsetLimit = offsetLimit;
    }

    public int getOffset() {
        return null != this.offsetLimit ? this.offsetLimit.getOffset() : 0;
    }

    public int getRowCount() {
        return null != this.rowCountLimit ? this.rowCountLimit.getRowCount() : 0;
    }

    public void processParameters(List<Object> parameters, boolean isRewrite) {
        this.fill(parameters);
        if (isRewrite) {
            this.rewrite(parameters);
        }
    }

    private void fill(List<Object> parameters) {
        int offset = 0;
        if (null != this.offsetLimit) {
            offset = -1 == this.offsetLimit.getOffsetParameterIndex() ? this.getOffset() : NumberUtil.roundHalfUp(parameters.get(this.offsetLimit.getOffsetParameterIndex()));
            this.offsetLimit.setOffset(offset);
        }
        int rowCount = 0;
        if (null != this.rowCountLimit) {
            rowCount = -1 == this.rowCountLimit.getRowCountParameterIndex() ? this.getRowCount() : NumberUtil.roundHalfUp(parameters.get(this.rowCountLimit.getRowCountParameterIndex()));
            this.rowCountLimit.setRowCount(rowCount);
        }
        if (offset < 0 || rowCount < 0) {
            throw new SQLParsingException("LIMIT offset and row count can not be a negative value.", new Object[0]);
        }
    }

    private void rewrite(List<Object> parameters) {
        int rewriteOffset = 0;
        int rewriteRowCount = this.getOffset() + this.rowCountLimit.getRowCount();
        if (null != this.offsetLimit && this.offsetLimit.getOffsetParameterIndex() > -1) {
            parameters.set(this.offsetLimit.getOffsetParameterIndex(), rewriteOffset);
        }
        if (null != this.rowCountLimit && this.rowCountLimit.getRowCountParameterIndex() > -1) {
            parameters.set(this.rowCountLimit.getRowCountParameterIndex(), rewriteRowCount);
        }
    }

    @ConstructorProperties(value={"offsetLimit", "rowCountLimit"})
    public Limit(OffsetLimit offsetLimit, RowCountLimit rowCountLimit) {
        this.offsetLimit = offsetLimit;
        this.rowCountLimit = rowCountLimit;
    }

    public OffsetLimit getOffsetLimit() {
        return this.offsetLimit;
    }

    public RowCountLimit getRowCountLimit() {
        return this.rowCountLimit;
    }

    public void setOffsetLimit(OffsetLimit offsetLimit) {
        this.offsetLimit = offsetLimit;
    }

    public void setRowCountLimit(RowCountLimit rowCountLimit) {
        this.rowCountLimit = rowCountLimit;
    }
}

