/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.context;

import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.IndexColumn;
import com.google.common.base.Optional;

public final class OrderBy
implements IndexColumn {
    private final Optional<String> owner;
    private final Optional<String> name;
    private final Optional<Integer> index;
    private final OrderType orderByType;
    private Optional<String> alias;
    private int columnIndex;

    public OrderBy(String name, OrderType orderByType, Optional<String> alias) {
        this.owner = Optional.absent();
        this.name = Optional.of((Object)name);
        this.index = Optional.absent();
        this.orderByType = orderByType;
        this.alias = alias;
    }

    public OrderBy(String owner, String name, OrderType orderByType, Optional<String> alias) {
        this.owner = Optional.of((Object)owner);
        this.name = Optional.of((Object)name);
        this.index = Optional.absent();
        this.orderByType = orderByType;
        this.alias = alias;
    }

    public OrderBy(int index, OrderType orderByType) {
        this.owner = Optional.absent();
        this.name = Optional.absent();
        this.index = Optional.of((Object)index);
        this.orderByType = orderByType;
        this.alias = Optional.absent();
        this.columnIndex = index;
    }

    @Override
    public Optional<String> getColumnLabel() {
        return this.alias;
    }

    @Override
    public Optional<String> getColumnName() {
        return this.name;
    }

    @Override
    public void setColumnIndex(int index) {
        if (this.index.isPresent()) {
            return;
        }
        this.columnIndex = index;
    }

    public Optional<String> getQualifiedName() {
        if (!this.name.isPresent()) {
            return Optional.absent();
        }
        return this.owner.isPresent() ? Optional.of((Object)((String)this.owner.get() + "." + (String)this.name.get())) : this.name;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Integer> getIndex() {
        return this.index;
    }

    public OrderType getOrderByType() {
        return this.orderByType;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)o;
        Optional<String> this$owner = this.getOwner();
        Optional<String> other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Optional<String> this$name = this.getName();
        Optional<String> other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<Integer> this$index = this.getIndex();
        Optional<Integer> other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        OrderType this$orderByType = this.getOrderByType();
        OrderType other$orderByType = other.getOrderByType();
        if (this$orderByType == null ? other$orderByType != null : !((Object)((Object)this$orderByType)).equals((Object)other$orderByType)) {
            return false;
        }
        Optional<String> this$alias = this.getAlias();
        Optional<String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        return this.getColumnIndex() == other.getColumnIndex();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 0 : $owner.hashCode());
        Optional<String> $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        Optional<Integer> $index = this.getIndex();
        result = result * 59 + ($index == null ? 0 : $index.hashCode());
        OrderType $orderByType = this.getOrderByType();
        result = result * 59 + ($orderByType == null ? 0 : ((Object)((Object)$orderByType)).hashCode());
        Optional<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 0 : $alias.hashCode());
        result = result * 59 + this.getColumnIndex();
        return result;
    }

    public String toString() {
        return "OrderBy(owner=" + this.getOwner() + ", name=" + this.getName() + ", index=" + this.getIndex() + ", orderByType=" + (Object)((Object)this.getOrderByType()) + ", alias=" + this.getAlias() + ", columnIndex=" + this.getColumnIndex() + ")";
    }

    public void setAlias(Optional<String> alias) {
        this.alias = alias;
    }
}

