/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.context;

import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.IndexColumn;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;

public final class GroupBy
implements IndexColumn {
    private final Optional<String> owner;
    private final String name;
    private final OrderType orderByType;
    private Optional<String> alias;
    private int columnIndex;

    public GroupBy(Optional<String> owner, String name, OrderType orderByType, Optional<String> alias) {
        this.owner = owner;
        this.name = name;
        this.orderByType = orderByType;
        this.alias = alias;
    }

    @Override
    public Optional<String> getColumnLabel() {
        return this.alias;
    }

    @Override
    public Optional<String> getColumnName() {
        return Optional.of((Object)this.name);
    }

    public Optional<String> getQualifiedName() {
        if (null == this.name) {
            return Optional.absent();
        }
        return this.owner.isPresent() ? Optional.of((Object)((String)this.owner.get() + "." + this.name)) : Optional.of((Object)this.name);
    }

    @ConstructorProperties(value={"owner", "name", "orderByType"})
    public GroupBy(Optional<String> owner, String name, OrderType orderByType) {
        this.owner = owner;
        this.name = name;
        this.orderByType = orderByType;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public OrderType getOrderByType() {
        return this.orderByType;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    public String toString() {
        return "GroupBy(owner=" + this.getOwner() + ", name=" + this.getName() + ", orderByType=" + (Object)((Object)this.getOrderByType()) + ", alias=" + this.getAlias() + ", columnIndex=" + this.getColumnIndex() + ")";
    }

    public void setAlias(Optional<String> alias) {
        this.alias = alias;
    }

    @Override
    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }
}

