/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.Lexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.AbstractParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table.Table;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table.Tables;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIdentifierExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIgnoreExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPropertyExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLTextExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.TableToken;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import java.util.LinkedList;

public class SQLParser
extends AbstractParser {
    private final ShardingRule shardingRule;
    private int parametersIndex;

    public SQLParser(Lexer lexer, ShardingRule shardingRule) {
        super(lexer);
        this.shardingRule = shardingRule;
    }

    public final SQLExpression parseExpression(SQLStatement sqlStatement) {
        int beginPosition = this.getLexer().getCurrentToken().getEndPosition();
        SQLExpression result = this.parseExpression();
        if (result instanceof SQLPropertyExpression) {
            this.setTableToken(sqlStatement, beginPosition, (SQLPropertyExpression)result);
        }
        return result;
    }

    public final SQLExpression parseExpression() {
        String literals = this.getLexer().getCurrentToken().getLiterals();
        SQLExpression expression = this.getExpression(literals);
        if (this.skipIfEqual(Literals.IDENTIFIER)) {
            if (this.skipIfEqual(Symbol.DOT)) {
                String property = this.getLexer().getCurrentToken().getLiterals();
                this.getLexer().nextToken();
                return this.skipIfCompositeExpression() ? new SQLIgnoreExpression() : new SQLPropertyExpression(new SQLIdentifierExpression(literals), property);
            }
            if (this.equalAny(Symbol.LEFT_PAREN)) {
                this.skipParentheses();
                this.skipRestCompositeExpression();
                return new SQLIgnoreExpression();
            }
            return this.skipIfCompositeExpression() ? new SQLIgnoreExpression() : expression;
        }
        this.getLexer().nextToken();
        return this.skipIfCompositeExpression() ? new SQLIgnoreExpression() : expression;
    }

    private SQLExpression getExpression(String literals) {
        if (this.equalAny(Symbol.QUESTION)) {
            ++this.parametersIndex;
            return new SQLPlaceholderExpression(this.parametersIndex - 1);
        }
        if (this.equalAny(Literals.CHARS)) {
            return new SQLTextExpression(literals);
        }
        if (this.equalAny(Literals.INT)) {
            return new SQLNumberExpression(Integer.parseInt(literals));
        }
        if (this.equalAny(Literals.FLOAT)) {
            return new SQLNumberExpression(Double.parseDouble(literals));
        }
        if (this.equalAny(Literals.HEX)) {
            return new SQLNumberExpression(Integer.parseInt(literals, 16));
        }
        if (this.equalAny(Literals.IDENTIFIER)) {
            return new SQLIdentifierExpression(SQLUtil.getExactlyValue(literals));
        }
        return new SQLIgnoreExpression();
    }

    private boolean skipIfCompositeExpression() {
        if (this.equalAny(Symbol.PLUS, Symbol.SUB, Symbol.STAR, Symbol.SLASH, Symbol.PERCENT, Symbol.AMP, Symbol.BAR, Symbol.DOUBLE_AMP, Symbol.DOUBLE_BAR, Symbol.CARET, Symbol.DOT, Symbol.LEFT_PAREN)) {
            this.skipParentheses();
            this.skipRestCompositeExpression();
            return true;
        }
        return false;
    }

    private void skipRestCompositeExpression() {
        while (this.skipIfEqual(Symbol.PLUS, Symbol.SUB, Symbol.STAR, Symbol.SLASH, Symbol.PERCENT, Symbol.AMP, Symbol.BAR, Symbol.DOUBLE_AMP, Symbol.DOUBLE_BAR, Symbol.CARET, Symbol.DOT)) {
            if (this.equalAny(Symbol.QUESTION)) {
                ++this.parametersIndex;
            }
            this.getLexer().nextToken();
            this.skipParentheses();
        }
    }

    private void setTableToken(SQLStatement sqlStatement, int beginPosition, SQLPropertyExpression propertyExpr) {
        String owner = propertyExpr.getOwner().getName();
        if (sqlStatement.getTables().getSingleTableName().equalsIgnoreCase(SQLUtil.getExactlyValue(owner))) {
            sqlStatement.getSqlTokens().add(new TableToken(beginPosition - owner.length(), owner));
        }
    }

    public Optional<String> parseAlias() {
        if (this.skipIfEqual(DefaultKeyword.AS)) {
            if (this.equalAny(Symbol.values())) {
                return Optional.absent();
            }
            String result = SQLUtil.getExactlyValue(this.getLexer().getCurrentToken().getLiterals());
            this.getLexer().nextToken();
            return Optional.of((Object)result);
        }
        if (this.equalAny(Literals.IDENTIFIER, Literals.CHARS, DefaultKeyword.USER, DefaultKeyword.END, DefaultKeyword.CASE, DefaultKeyword.KEY, DefaultKeyword.INTERVAL, DefaultKeyword.CONSTRAINT)) {
            String result = SQLUtil.getExactlyValue(this.getLexer().getCurrentToken().getLiterals());
            this.getLexer().nextToken();
            return Optional.of((Object)result);
        }
        return Optional.absent();
    }

    public final void parseSingleTable(SQLStatement sqlStatement) {
        Table table;
        boolean hasParentheses = false;
        if (this.skipIfEqual(Symbol.LEFT_PAREN)) {
            if (this.equalAny(DefaultKeyword.SELECT)) {
                throw new UnsupportedOperationException("Cannot support subquery");
            }
            hasParentheses = true;
        }
        int beginPosition = this.getLexer().getCurrentToken().getEndPosition() - this.getLexer().getCurrentToken().getLiterals().length();
        String literals = this.getLexer().getCurrentToken().getLiterals();
        this.getLexer().nextToken();
        if (this.skipIfEqual(Symbol.DOT)) {
            this.getLexer().nextToken();
            if (hasParentheses) {
                this.accept(Symbol.RIGHT_PAREN);
            }
            table = new Table(SQLUtil.getExactlyValue(literals), this.parseAlias());
        } else {
            if (hasParentheses) {
                this.accept(Symbol.RIGHT_PAREN);
            }
            table = new Table(SQLUtil.getExactlyValue(literals), this.parseAlias());
        }
        if (this.skipJoin()) {
            throw new UnsupportedOperationException("Cannot support Multiple-Table.");
        }
        sqlStatement.getSqlTokens().add(new TableToken(beginPosition, literals));
        sqlStatement.getTables().add(table);
    }

    public final boolean skipJoin() {
        if (this.skipIfEqual(DefaultKeyword.LEFT, DefaultKeyword.RIGHT, DefaultKeyword.FULL)) {
            this.skipIfEqual(DefaultKeyword.OUTER);
            this.accept(DefaultKeyword.JOIN);
            return true;
        }
        if (this.skipIfEqual(DefaultKeyword.INNER)) {
            this.accept(DefaultKeyword.JOIN);
            return true;
        }
        if (this.skipIfEqual(DefaultKeyword.JOIN, Symbol.COMMA, DefaultKeyword.STRAIGHT_JOIN)) {
            return true;
        }
        return this.skipIfEqual(DefaultKeyword.CROSS) ? this.skipIfEqual(DefaultKeyword.JOIN, DefaultKeyword.APPLY) : this.skipIfEqual(DefaultKeyword.OUTER) && this.skipIfEqual(DefaultKeyword.APPLY);
    }

    public final void parseWhere(SQLStatement sqlStatement) {
        if (this.skipIfEqual(DefaultKeyword.WHERE)) {
            this.parseConditions(sqlStatement);
        }
    }

    private void parseConditions(SQLStatement sqlStatement) {
        do {
            this.parseComparisonCondition(sqlStatement);
        } while (this.skipIfEqual(DefaultKeyword.AND));
        if (this.equalAny(DefaultKeyword.OR)) {
            throw new SQLParsingUnsupportedException(this.getLexer().getCurrentToken().getType());
        }
    }

    public final void parseComparisonCondition(SQLStatement sqlStatement) {
        this.skipIfEqual(Symbol.LEFT_PAREN);
        SQLExpression left = this.parseExpression(sqlStatement);
        if (this.equalAny(Symbol.EQ)) {
            this.parseEqualCondition(sqlStatement, left);
            return;
        }
        if (this.equalAny(DefaultKeyword.IN)) {
            this.parseInCondition(sqlStatement, left);
            return;
        }
        if (this.equalAny(DefaultKeyword.BETWEEN)) {
            this.parseBetweenCondition(sqlStatement, left);
            return;
        }
        if (this.equalAny(Symbol.LT) || this.equalAny(Symbol.GT) || this.equalAny(Symbol.LT_EQ) || this.equalAny(Symbol.GT_EQ)) {
            this.parserOtherCondition(sqlStatement);
        }
        this.skipIfEqual(Symbol.LEFT_PAREN);
    }

    private void parseEqualCondition(SQLStatement sqlStatement, SQLExpression left) {
        Optional<Column> column;
        this.getLexer().nextToken();
        SQLExpression right = this.parseExpression(sqlStatement);
        if ((sqlStatement.getTables().isSingleTable() || left instanceof SQLPropertyExpression) && (right instanceof SQLNumberExpression || right instanceof SQLTextExpression || right instanceof SQLPlaceholderExpression) && (column = this.find(sqlStatement.getTables(), left)).isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), right), this.shardingRule);
        }
    }

    private void parseInCondition(SQLStatement sqlStatement, SQLExpression left) {
        this.getLexer().nextToken();
        this.accept(Symbol.LEFT_PAREN);
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        do {
            if (this.equalAny(Symbol.COMMA)) {
                this.getLexer().nextToken();
            }
            rights.add(this.parseExpression(sqlStatement));
        } while (!this.equalAny(Symbol.RIGHT_PAREN));
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), rights), this.shardingRule);
        }
        this.getLexer().nextToken();
    }

    private void parseBetweenCondition(SQLStatement sqlStatement, SQLExpression left) {
        this.getLexer().nextToken();
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        rights.add(this.parseExpression(sqlStatement));
        this.accept(DefaultKeyword.AND);
        rights.add(this.parseExpression(sqlStatement));
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), (SQLExpression)rights.get(0), (SQLExpression)rights.get(1)), this.shardingRule);
        }
    }

    private void parserOtherCondition(SQLStatement sqlStatement) {
        this.getLexer().nextToken();
        this.parseExpression(sqlStatement);
    }

    private Optional<Column> find(Tables tables, SQLExpression sqlExpression) {
        if (sqlExpression instanceof SQLPropertyExpression) {
            return this.getColumnWithOwner(tables, (SQLPropertyExpression)sqlExpression);
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            return this.getColumnWithoutOwner(tables, (SQLIdentifierExpression)sqlExpression);
        }
        return Optional.absent();
    }

    private Optional<Column> getColumnWithOwner(Tables tables, SQLPropertyExpression propertyExpression) {
        Optional<Table> table = tables.find(SQLUtil.getExactlyValue(propertyExpression.getOwner().getName()));
        return propertyExpression.getOwner() instanceof SQLIdentifierExpression && table.isPresent() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(propertyExpression.getName()), ((Table)table.get()).getName())) : Optional.absent();
    }

    private Optional<Column> getColumnWithoutOwner(Tables tables, SQLIdentifierExpression identifierExpression) {
        return tables.isSingleTable() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(identifierExpression.getName()), tables.getSingleTableName())) : Optional.absent();
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public int getParametersIndex() {
        return this.parametersIndex;
    }

    public void setParametersIndex(int parametersIndex) {
        this.parametersIndex = parametersIndex;
    }
}

