/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row;

import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.AbstractResultSetRow;
import com.dangdang.ddframe.rdb.sharding.merger.util.ResultSetUtil;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.OrderBy;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class OrderByResultSetRow
extends AbstractResultSetRow
implements Comparable<OrderByResultSetRow> {
    private final List<OrderBy> orderBies;
    private final List<Comparable<?>> orderByValues;

    public OrderByResultSetRow(ResultSet resultSet, List<OrderBy> orderBies) throws SQLException {
        super(resultSet);
        this.orderBies = orderBies;
        this.orderByValues = this.loadOrderByValues();
    }

    private List<Comparable<?>> loadOrderByValues() {
        ArrayList result = new ArrayList(this.orderBies.size());
        for (OrderBy each : this.orderBies) {
            Object value = this.getCell(each.getColumnIndex());
            Preconditions.checkState((boolean)(value instanceof Comparable), (Object)"Sharding-JDBC: order by value must extends Comparable");
            result.add((Comparable)value);
        }
        return result;
    }

    @Override
    public int compareTo(OrderByResultSetRow otherOrderByValue) {
        for (int i = 0; i < this.orderBies.size(); ++i) {
            OrderBy thisOrderBy = this.orderBies.get(i);
            int result = ResultSetUtil.compareTo(this.orderByValues.get(i), otherOrderByValue.orderByValues.get(i), thisOrderBy.getOrderByType());
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        return String.format("Order by columns value is %s", this.orderByValues);
    }
}

